// IPrinterService.aidl
package com.prints.printerservice;
import com.prints.printerservice.IPrinterCallback;
import android.graphics.Bitmap;

// Declare any non-default types here with import statements

interface IPrinterService {
    /**
     * Demonstrates some basic types that you can use as parameters
     * and return values in AIDL.
     */

    void upgradePrinter();

    String getFirmwareVersion();

    String getBootloaderVersion();

    void printerInit(in IPrinterCallback callback);


    /**
     * Force reset the printer MCU.  This will execute below items:
     * (1)power off printer mcu
     * (2)power on printer mcu
     * (3)printer init & self-checking
     * (4)wait for print user task
     *
     * Normally,user is no need to call printerReset to reset printer MUC.
     *
     * The printer reset task always needs (1-5)s.And it's asynchronous with print task.It's run in child thread.
     *
     * If the printer has some errors or not responding,we can call printerReset to fix the problem.
     * printerReset just need to be executed only once.
     *
     */
    void printerReset(in IPrinterCallback callback);

    void printWrapPaper(int n, in IPrinterCallback callback);

    void printText(String text, in IPrinterCallback callback);

    void printTextWithAttributes(String text, in Map attributes, in IPrinterCallback callback);

    void printStart(in IPrinterCallback callback);

    void printColumnsTextWithAttributes(in String[] text, in List attributes,in IPrinterCallback callback);

    void printBitmap(in Bitmap bitmap, in IPrinterCallback callback);

    //xc modify
    void printBitmapWidth(in Bitmap bitmap, in IPrinterCallback callback);
    //xc modify

    void printBitmapWithAttributes(in Bitmap bitmap, in Map attributes, in IPrinterCallback callback);

    void printBarCode(String content,int align,int width,int height,boolean showContent,in IPrinterCallback callback);
    /***
     * @param content (eg.www.baidu.com)
     * @param align (0:left 1:center 2:right)
     * @param size (px eg.:200)
     * **/
    void printQRCode(String text, int align, int size, in IPrinterCallback callback);

    //(1,2,3,4,5,6)
    void setPrinterSpeed(int level, in IPrinterCallback callback);

    void sendRAWData(in byte[] data, in IPrinterCallback callback);

    //0:(result > 65)  1:(result <=65)
    int printerTemperature(in IPrinterCallback callback);

    boolean printerPaper(in IPrinterCallback callback);

    // add by dongguosen for UPFD-208 20211106 Start
    int printerHSStart(in IPrinterCallback callback);
    //0:(false)  1:(true)
    // add by dongguosen for UPFD-208 20211106 End
    void setPrintEncode(String encode, in IPrinterCallback callback);

    void setDefaultPrintEncode(in IPrinterCallback callback);

    void printBarCodeWithPos(String content,int align,int width,int height,int contentPos,int format,in IPrinterCallback callback);

    void printQRCodeWithErr(String text, int align, int size, int error, in IPrinterCallback callback);

    void setAlignment(in int align, in IPrinterCallback callback);

    void setFontSize(int fontsize, in IPrinterCallback callback);

    void printTextWithFont(String text, int typeface, int fontsize, in IPrinterCallback callback);

    void printColumnsString(in String[] text, in int[] width, in int[] align, in IPrinterCallback callback);

    void setPrinterStyle(String key, int value, in IPrinterCallback callback);

    int updatePrinterState(in IPrinterCallback callback);

    int getRAWDataRet(in byte[] data, in IPrinterCallback callback);

    void sendPackageData(in byte[] data);
}
