/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RelativeLayout;

public class RelativeRadioGroup
extends RelativeLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;

    public RelativeRadioGroup(Context context) {
        super(context);
        this.init();
    }

    public RelativeRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        RadioButton button;
        if (child instanceof RadioButton && (button = (RadioButton)child).isChecked()) {
            this.mProtectFromCheckedChange = true;
            if (this.mCheckedId != -1) {
                this.setCheckedStateForView(this.mCheckedId, false);
            }
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(button.getId());
        }
        super.addView(child, index, params);
    }

    public void check(int id2) {
        if (id2 != -1 && id2 == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(int id2) {
        this.mCheckedId = id2;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView instanceof RadioButton) {
            ((RadioButton)checkedView).setChecked(checked);
        }
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected RelativeLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)RelativeRadioGroup.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)RelativeRadioGroup.class.getName());
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (parent == RelativeRadioGroup.this && child instanceof RadioButton) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = child.hashCode();
                    child.setId(id2);
                }
                ((RadioButton)child).setOnCheckedChangeListener(RelativeRadioGroup.this.mChildOnCheckedChangeListener);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == RelativeRadioGroup.this && child instanceof RadioButton) {
                ((RadioButton)child).setOnCheckedChangeListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (RelativeRadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            RelativeRadioGroup.this.mProtectFromCheckedChange = true;
            if (RelativeRadioGroup.this.mCheckedId != -1) {
                RelativeRadioGroup.this.setCheckedStateForView(RelativeRadioGroup.this.mCheckedId, false);
            }
            RelativeRadioGroup.this.mProtectFromCheckedChange = false;
            int id2 = buttonView.getId();
            RelativeRadioGroup.this.setCheckedId(id2);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(RelativeRadioGroup var1, int var2);
    }

    public static class LayoutParams
    extends RelativeLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -2;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }
    }
}

