/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

public class Endian {
    public static boolean be2boolean(byte[] bytes, int offset) {
        return bytes[offset] != 0;
    }

    public static boolean le2boolean(byte[] bytes, int offset) {
        return bytes[offset] != 0;
    }

    public static char be2char(byte[] bytes, int offset) {
        return (char)((bytes[offset + 1] & 0xFF) + (bytes[offset] << 8));
    }

    public static char le2char(byte[] bytes, int offset) {
        return (char)((bytes[offset] & 0xFF) + (bytes[offset + 1] << 8));
    }

    public static short be2short(byte[] bytes, int offset) {
        return (short)((bytes[offset + 1] & 0xFF) + (bytes[offset] << 8));
    }

    public static short le2short(byte[] bytes, int offset) {
        return (short)((bytes[offset] & 0xFF) + (bytes[offset + 1] << 8));
    }

    public static int be2int(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) + ((bytes[offset + 2] & 0xFF) << 8) + ((bytes[offset + 1] & 0xFF) << 16) + (bytes[offset] << 24);
    }

    public static int le2int(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) + ((bytes[offset + 1] & 0xFF) << 8) + ((bytes[offset + 2] & 0xFF) << 16) + (bytes[offset + 3] << 24);
    }

    public static float be2float(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Endian.be2int(bytes, offset));
    }

    public static float le2float(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Endian.le2int(bytes, offset));
    }

    public static long be2long(byte[] bytes, int offset) {
        return ((long)bytes[offset + 7] & 0xFFL) + (((long)bytes[offset + 6] & 0xFFL) << 8) + (((long)bytes[offset + 5] & 0xFFL) << 16) + (((long)bytes[offset + 4] & 0xFFL) << 24) + (((long)bytes[offset + 3] & 0xFFL) << 32) + (((long)bytes[offset + 2] & 0xFFL) << 40) + (((long)bytes[offset + 1] & 0xFFL) << 48) + ((long)bytes[offset] << 56);
    }

    public static long le2long(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) + (((long)bytes[offset + 1] & 0xFFL) << 8) + (((long)bytes[offset + 2] & 0xFFL) << 16) + (((long)bytes[offset + 3] & 0xFFL) << 24) + (((long)bytes[offset + 4] & 0xFFL) << 32) + (((long)bytes[offset + 5] & 0xFFL) << 40) + (((long)bytes[offset + 6] & 0xFFL) << 48) + ((long)bytes[offset + 7] << 56);
    }

    public static double be2double(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Endian.be2long(bytes, offset));
    }

    public static double le2double(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Endian.le2long(bytes, offset));
    }

    public static void bool2be(byte[] bytes, int offset, boolean value) {
        bytes[offset] = (byte)(value ? 1 : 0);
    }

    public static void bool2le(byte[] bytes, int offset, boolean value) {
        bytes[offset] = (byte)(value ? 1 : 0);
    }

    public static void char2be(byte[] bytes, int offset, char value) {
        bytes[offset + 1] = (byte)value;
        bytes[offset] = (byte)(value >>> 8);
    }

    public static void char2le(byte[] bytes, int offset, char value) {
        bytes[offset] = (byte)value;
        bytes[offset + 1] = (byte)(value >>> 8);
    }

    public static void short2be(byte[] b, int offset, short value) {
        b[offset + 1] = (byte)value;
        b[offset] = (byte)(value >>> 8);
    }

    public static void short2le(byte[] b, int offset, short value) {
        b[offset] = (byte)value;
        b[offset + 1] = (byte)(value >>> 8);
    }

    public static void int2be(byte[] bytes, int offset, int value) {
        bytes[offset + 3] = (byte)value;
        bytes[offset + 2] = (byte)(value >>> 8);
        bytes[offset + 1] = (byte)(value >>> 16);
        bytes[offset] = (byte)(value >>> 24);
    }

    public static void int2le(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)value;
        bytes[offset + 1] = (byte)(value >>> 8);
        bytes[offset + 2] = (byte)(value >>> 16);
        bytes[offset + 3] = (byte)(value >>> 24);
    }

    public static void float2be(byte[] bytes, int offset, float value) {
        Endian.int2be(bytes, offset, Float.floatToIntBits(value));
    }

    public static void float2le(byte[] bytes, int offset, float value) {
        Endian.int2le(bytes, offset, Float.floatToIntBits(value));
    }

    public static void long2be(byte[] bytes, int offset, long val) {
        bytes[offset + 7] = (byte)val;
        bytes[offset + 6] = (byte)(val >>> 8);
        bytes[offset + 5] = (byte)(val >>> 16);
        bytes[offset + 4] = (byte)(val >>> 24);
        bytes[offset + 3] = (byte)(val >>> 32);
        bytes[offset + 2] = (byte)(val >>> 40);
        bytes[offset + 1] = (byte)(val >>> 48);
        bytes[offset] = (byte)(val >>> 56);
    }

    public static void long2le(byte[] bytes, int offset, long val) {
        bytes[offset] = (byte)val;
        bytes[offset + 1] = (byte)(val >>> 8);
        bytes[offset + 2] = (byte)(val >>> 16);
        bytes[offset + 3] = (byte)(val >>> 24);
        bytes[offset + 4] = (byte)(val >>> 32);
        bytes[offset + 5] = (byte)(val >>> 40);
        bytes[offset + 6] = (byte)(val >>> 48);
        bytes[offset + 7] = (byte)(val >>> 56);
    }

    public static void double2be(byte[] bytes, int offset, double value) {
        Endian.long2be(bytes, offset, Double.doubleToLongBits(value));
    }

    public static void double2le(byte[] bytes, int offset, double value) {
        Endian.long2le(bytes, offset, Double.doubleToLongBits(value));
    }
}

