/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.app.Activity;
import android.app.admin.DeviceAdminReceiver;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;

public class DeviceAdminReceiverLock
extends DeviceAdminReceiver {
    public static final String EXTRA_REQUEST_FINISH = "EXTRA_REQUEST_FINISH";
    private static final int REQ_SCREEN_LOCK = 412809;

    public static void requestScreenLock(@NonNull Activity activity, boolean finish) {
        if (!DeviceAdminReceiverLock.checkScreenLock(activity, finish)) {
            Intent intent = new Intent("android.app.action.ADD_DEVICE_ADMIN");
            intent.putExtra("android.app.extra.DEVICE_ADMIN", (Parcelable)new ComponentName((Context)activity, DeviceAdminReceiverLock.class));
            intent.putExtra(EXTRA_REQUEST_FINISH, finish);
            activity.startActivityForResult(intent, 412809);
        }
    }

    private static boolean checkScreenLock(@NonNull Activity activity, boolean finish) {
        ComponentName cn = new ComponentName((Context)activity, DeviceAdminReceiverLock.class);
        DevicePolicyManager dpm = (DevicePolicyManager)activity.getSystemService("device_policy");
        if (dpm.isAdminActive(cn)) {
            dpm.lockNow();
            if (finish) {
                activity.finish();
            }
            return true;
        }
        return false;
    }

    public static boolean onActivityResult(@NonNull Activity activity, int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 412809: {
                if (resultCode != -1) break;
                boolean finish = data != null && data.getBooleanExtra(EXTRA_REQUEST_FINISH, false);
                DeviceAdminReceiverLock.checkScreenLock(activity, finish);
                return true;
            }
        }
        return false;
    }
}

