/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;
import com.serenegiant.utils.LogUtils;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CrashExceptionHandler
implements Thread.UncaughtExceptionHandler {
    static final String LOG_NAME = "crashrepo.txt";
    static final String MAIL_TO = "t_saki@serenegiant.com";
    private final WeakReference<Context> mWeakContext;
    private final WeakReference<PackageInfo> mWeakPackageInfo;
    private final Thread.UncaughtExceptionHandler mHandler;

    public static void registerCrashHandler(@NonNull Context app_context) {
        Thread.setDefaultUncaughtExceptionHandler(new CrashExceptionHandler(app_context));
    }

    private CrashExceptionHandler(@NonNull Context context) {
        this.mWeakContext = new WeakReference<Context>(context);
        try {
            this.mWeakPackageInfo = new WeakReference<PackageInfo>(context.getPackageManager().getPackageInfo(context.getPackageName(), 0));
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.mHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        Context context = (Context)this.mWeakContext.get();
        if (context != null) {
            try (PrintWriter writer = null;){
                FileOutputStream outputStream = context.openFileOutput(LOG_NAME, 0);
                writer = new PrintWriter(outputStream);
                JSONObject json = new JSONObject();
                json.put("Build", (Object)this.getBuildInfo());
                json.put("PackageInfo", (Object)this.getPackageInfo());
                json.put("Exception", (Object)this.getExceptionInfo(throwable));
                json.put("SharedPreferences", (Object)this.getPreferencesInfo());
                writer.print(json.toString());
                writer.flush();
            }
        }
        try {
            if (this.mHandler != null) {
                this.mHandler.uncaughtException(thread, throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONObject getBuildInfo() throws JSONException {
        JSONObject buildJson = new JSONObject();
        buildJson.put("BRAND", (Object)Build.BRAND);
        buildJson.put("MODEL", (Object)Build.MODEL);
        buildJson.put("DEVICE", (Object)Build.DEVICE);
        buildJson.put("MANUFACTURER", (Object)Build.MANUFACTURER);
        buildJson.put("VERSION.SDK_INT", Build.VERSION.SDK_INT);
        buildJson.put("VERSION.RELEASE", (Object)Build.VERSION.RELEASE);
        return buildJson;
    }

    private JSONObject getPackageInfo() throws JSONException {
        PackageInfo info = (PackageInfo)this.mWeakPackageInfo.get();
        JSONObject packageInfoJson = new JSONObject();
        if (info != null) {
            packageInfoJson.put("packageName", (Object)info.packageName);
            packageInfoJson.put("versionCode", info.versionCode);
            packageInfoJson.put("versionName", (Object)info.versionName);
        }
        return packageInfoJson;
    }

    private JSONObject getExceptionInfo(Throwable throwable) throws JSONException {
        JSONObject exceptionJson = new JSONObject();
        exceptionJson.put("name", (Object)throwable.getClass().getName());
        exceptionJson.put("cause", (Object)throwable.getCause());
        exceptionJson.put("message", (Object)throwable.getMessage());
        JSONArray stackTrace = new JSONArray();
        for (StackTraceElement element : throwable.getStackTrace()) {
            stackTrace.put((Object)("at " + LogUtils.getMetaInfo(element)));
        }
        exceptionJson.put("stacktrace", (Object)stackTrace);
        return exceptionJson;
    }

    private JSONObject getPreferencesInfo() throws JSONException {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)((Context)this.mWeakContext.get()));
        JSONObject preferencesJson = new JSONObject();
        Map map = preferences.getAll();
        for (Map.Entry entry : map.entrySet()) {
            preferencesJson.put((String)entry.getKey(), entry.getValue());
        }
        return preferencesJson;
    }
}

