/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.serenegiant.common.R;
import com.serenegiant.mediastore.MediaStoreHelper;
import java.io.IOException;

public class MediaStoreImageAdapter
extends PagerAdapter {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreImageAdapter.class.getSimpleName();
    private final LayoutInflater mInflater;
    private final int mLayoutId;
    private final ContentResolver mCr;
    private final MyAsyncQueryHandler mQueryHandler;
    protected boolean mDataValid;
    protected int mRowIDColumn;
    protected ChangeObserver mChangeObserver;
    protected DataSetObserver mDataSetObserver;
    private Cursor mCursor;
    private String mSelection = MediaStoreHelper.SELECTIONS[1];
    private String[] mSelectionArgs = null;
    private boolean mShowTitle;

    public MediaStoreImageAdapter(Context context, int id_layout) {
        this(context, id_layout, true);
    }

    public MediaStoreImageAdapter(Context context, int id_layout, boolean needQuery) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = id_layout;
        this.mCr = context.getContentResolver();
        this.mQueryHandler = new MyAsyncQueryHandler(this.mCr, this);
        if (needQuery) {
            this.startQuery();
        }
    }

    protected void finalize() throws Throwable {
        this.changeCursor(null);
        super.finalize();
    }

    public int getCount() {
        if (this.mDataValid && this.mCursor != null) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View view = this.mInflater.inflate(this.mLayoutId, container, false);
        if (view != null) {
            container.addView(view);
            ViewHolder holder = (ViewHolder)view.getTag();
            if (holder == null) {
                holder = new ViewHolder();
            }
            TextView tv = holder.mTitleView = (TextView)view.findViewById(R.id.title);
            ImageView iv = holder.mImageView = (ImageView)view.findViewById(R.id.thumbnail);
            if (holder.info == null) {
                holder.info = new MediaStoreHelper.MediaInfo();
            }
            holder.info.loadFromCursor(this.getCursor(position));
            Drawable drawable2 = iv.getDrawable();
            if (!(drawable2 instanceof MediaStoreHelper.LoaderDrawable)) {
                drawable2 = this.createLoaderDrawable(this.mCr, holder.info);
                iv.setImageDrawable(drawable2);
            }
            ((MediaStoreHelper.LoaderDrawable)drawable2).startLoad(holder.info.mediaType, 0, holder.info.id);
            if (tv != null) {
                tv.setVisibility(this.mShowTitle ? 0 : 8);
                if (this.mShowTitle) {
                    tv.setText((CharSequence)holder.info.title);
                }
            }
        }
        return view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (object instanceof View) {
            container.removeView((View)object);
        }
    }

    public int getItemPosition(@NonNull Object object) {
        return super.getItemPosition(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemPositionFromID(long id2) {
        int result;
        block7: {
            result = -1;
            Cursor cursor = this.mCr.query(MediaStoreHelper.QUERY_URI, MediaStoreHelper.PROJ_MEDIA, this.mSelection, this.mSelectionArgs, null);
            if (cursor != null) {
                try {
                    if (!cursor.moveToFirst()) break block7;
                    int ix = 0;
                    while (true) {
                        if (cursor.getLong(0) == id2) {
                            result = ix;
                            break;
                        }
                        if (!cursor.moveToNext()) {
                            break;
                        }
                        ++ix;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return result;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view.equals(object);
    }

    protected void changeCursor(@Nullable Cursor cursor) {
        Cursor old = this.swapCursor(cursor);
        if (old != null && !old.isClosed()) {
            old.close();
        }
    }

    protected Cursor getCursor(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    protected Cursor swapCursor(Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return null;
        }
        Cursor oldCursor = this.mCursor;
        if (oldCursor != null) {
            if (this.mChangeObserver != null) {
                oldCursor.unregisterContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                oldCursor.unregisterDataSetObserver(this.mDataSetObserver);
            }
        }
        this.mCursor = newCursor;
        if (newCursor != null) {
            if (this.mChangeObserver != null) {
                newCursor.registerContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                newCursor.registerDataSetObserver(this.mDataSetObserver);
            }
            this.mRowIDColumn = newCursor.getColumnIndexOrThrow("_id");
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            this.mRowIDColumn = -1;
            this.mDataValid = false;
            this.notifyDataSetInvalidated();
        }
        return oldCursor;
    }

    public void notifyDataSetInvalidated() {
    }

    public void startQuery() {
        this.mQueryHandler.requery();
    }

    protected MediaStoreHelper.LoaderDrawable createLoaderDrawable(ContentResolver cr, MediaStoreHelper.MediaInfo info) {
        return new ImageLoaderDrawable(cr, info.width, info.height);
    }

    private static class MyImageLoader
    extends MediaStoreHelper.ImageLoader {
        public MyImageLoader(ImageLoaderDrawable parent) {
            super(parent);
        }

        @Override
        protected Bitmap loadBitmap(ContentResolver cr, int mediaType, int hashCode, long id2, int requestWidth, int requestHeight) {
            Bitmap result = null;
            try {
                result = MediaStoreHelper.getImage(cr, id2, requestWidth, requestHeight);
                if (result != null) {
                    int w = result.getWidth();
                    int h = result.getHeight();
                    Rect bounds = new Rect();
                    this.mParent.copyBounds(bounds);
                    int cx = bounds.centerX();
                    int cy = bounds.centerY();
                    bounds.set(cx - w / 2, cy - h / w, cx + w / 2, cy + h / 2);
                    this.mParent.onBoundsChange(bounds);
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            return result;
        }
    }

    private static class ImageLoaderDrawable
    extends MediaStoreHelper.LoaderDrawable {
        public ImageLoaderDrawable(ContentResolver cr, int width, int height) {
            super(cr, width, height);
        }

        @Override
        protected MediaStoreHelper.ImageLoader createThumbnailLoader() {
            return new MyImageLoader(this);
        }

        @Override
        protected Bitmap checkBitmapCache(int hashCode, long id2) {
            return null;
        }
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        public void onChanged() {
            MediaStoreImageAdapter.this.mDataValid = true;
            MediaStoreImageAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            MediaStoreImageAdapter.this.mDataValid = false;
            MediaStoreImageAdapter.this.notifyDataSetInvalidated();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            MediaStoreImageAdapter.this.startQuery();
        }
    }

    private static final class MyAsyncQueryHandler
    extends AsyncQueryHandler {
        private final MediaStoreImageAdapter mAdapter;

        public MyAsyncQueryHandler(ContentResolver cr, MediaStoreImageAdapter adapter) {
            super(cr);
            this.mAdapter = adapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requery() {
            MediaStoreImageAdapter mediaStoreImageAdapter = this.mAdapter;
            synchronized (mediaStoreImageAdapter) {
                this.startQuery(0, (Object)this.mAdapter, MediaStoreHelper.QUERY_URI, MediaStoreHelper.PROJ_MEDIA, this.mAdapter.mSelection, this.mAdapter.mSelectionArgs, null);
            }
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            Cursor oldCursor = this.mAdapter.swapCursor(cursor);
            if (oldCursor != null && !oldCursor.isClosed()) {
                oldCursor.close();
            }
        }
    }

    private static final class ViewHolder {
        TextView mTitleView;
        ImageView mImageView;
        MediaStoreHelper.MediaInfo info;

        private ViewHolder() {
        }
    }
}

