/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.util.Log;
import com.serenegiant.media.AbstractVideoEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecHelper;
import com.serenegiant.media.Recorder;
import com.serenegiant.media.VideoConfig;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public final class VideoEncoder
extends AbstractVideoEncoder {
    private static final String TAG = VideoEncoder.class.getSimpleName();
    private static boolean isLoaded = false;
    protected long mNativePtr;
    private final boolean mAlign16;
    private int mColorFormat;
    private int BUF_SIZE;
    private byte[] mEncodeBytes;

    public VideoEncoder(Recorder recorder, EncoderListener listener, boolean align16) {
        super("video/avc", recorder, listener);
        this.BUF_SIZE = this.mWidth * (int)Math.ceil((float)this.mHeight / 16.0f) * 16 * 2 * 3 / 4;
        this.mEncodeBytes = new byte[this.BUF_SIZE];
        this.mAlign16 = align16;
        this.mNativePtr = this.nativeCreate();
    }

    @Override
    protected boolean internalPrepare() throws Exception {
        this.mRecorderStarted = false;
        this.mIsCapturing = true;
        this.mIsEOS = false;
        MediaCodecInfo codecInfo = MediaCodecHelper.selectVideoEncoder("video/avc");
        if (codecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return true;
        }
        boolean mayFail = this.mWidth >= 1000 || this.mHeight >= 1000;
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mWidth, (int)this.mHeight);
        this.mColorFormat = MediaCodecHelper.selectColorFormat(codecInfo, "video/avc");
        format.setInteger("color-format", this.mColorFormat);
        format.setInteger("bitrate", this.mBitRate > 0 ? this.mBitRate : VideoConfig.getBitrate(this.mWidth, this.mHeight));
        format.setInteger("frame-rate", this.mFramerate > 0 ? this.mFramerate : VideoConfig.getCaptureFps());
        format.setInteger("i-frame-interval", this.mIFrameIntervals > 0 ? this.mIFrameIntervals : VideoConfig.getIFrame());
        Log.d((String)TAG, (String)("format: " + format));
        this.mMediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
        this.mMediaCodec.configure(format, null, null, 1);
        this.mMediaCodec.start();
        if (this.mAlign16) {
            if (this.mWidth / 16 * 16 != this.mWidth) {
                this.mWidth = (this.mWidth / 16 + 1) * 16;
            }
            if (this.mHeight / 16 * 16 != this.mHeight) {
                this.mHeight = (this.mHeight / 16 + 1) * 16;
            }
        }
        VideoEncoder.nativePrepare(this.mNativePtr, this.mWidth, this.mHeight, MediaCodecHelper.selectColorFormat(codecInfo, "video/avc"));
        return mayFail;
    }

    @Override
    public void stop() {
        if (this.mNativePtr != 0L) {
            VideoEncoder.nativeStop(this.mNativePtr);
        }
        super.stop();
    }

    @Override
    public void release() {
        this.stop();
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        super.release();
    }

    @Override
    protected synchronized boolean startRecorder(IRecorder recorder, MediaFormat outFormat) {
        int h;
        int w;
        try {
            w = outFormat.getInteger("width");
        }
        catch (Exception e) {
            w = this.mWidth;
        }
        try {
            h = outFormat.getInteger("height");
        }
        catch (Exception e) {
            h = this.mHeight;
        }
        VideoEncoder.nativeResize(this.mNativePtr, w, h, this.mColorFormat);
        int sz = w * h * 2 * 3 / 4;
        if (sz != this.BUF_SIZE) {
            this.BUF_SIZE = sz;
            this.mEncodeBytes = new byte[this.BUF_SIZE];
        }
        return super.startRecorder(recorder, outFormat);
    }

    @Override
    protected void stopRecorder(IRecorder recorder) {
        if (this.mRecorderStarted) {
            VideoEncoder.nativeStop(this.mNativePtr);
        }
        super.stopRecorder(recorder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(ByteBuffer buffer) {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
        }
        try {
            buffer.rewind();
            this.encode(buffer, buffer.limit(), this.getInputPTSUs());
        }
        catch (Exception e) {
            this.callOnError(e);
        }
    }

    @Override
    public int getCaptureFormat() {
        return -1;
    }

    private final native long nativeCreate();

    private final native void nativeDestroy(long var1);

    private static final native int nativePrepare(long var0, int var2, int var3, int var4);

    private static final native int nativeResize(long var0, int var2, int var3, int var4);

    private static final native int nativeStop(long var0);

    static {
        if (!isLoaded) {
            System.loadLibrary("c++_shared");
            System.loadLibrary("jpeg-turbo2000");
            System.loadLibrary("png16");
            System.loadLibrary("common");
            System.loadLibrary("mediaencoder");
            isLoaded = true;
        }
    }
}

