/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.IMediaCodec;
import com.serenegiant.media.IMediaCodecCallback;
import com.serenegiant.utils.BuildCheck;
import com.serenegiant.utils.Time;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

@TargetApi(value=16)
public abstract class MediaDecoder
implements IMediaCodec {
    private static final boolean DEBUG = false;
    private static final String TAG_STATIC = MediaDecoder.class.getSimpleName();
    protected final String TAG = this.getClass().getSimpleName();
    protected static final int STATE_UNINITIALIZED = 0;
    protected static final int STATE_INITIALIZED = 1;
    protected static final int STATE_PREPARED = 2;
    protected static final int STATE_PLAYING = 3;
    protected static final int STATE_PAUSED = 4;
    protected static final int STATE_WAIT = 5;
    private static final int TIMEOUT_USEC = 10000;
    private final Object mSync = new Object();
    private IMediaCodecCallback mCallback;
    private volatile boolean mIsRunning;
    private volatile boolean mInputDone;
    private volatile boolean mOutputDone;
    private MediaMetadataRetriever mMediaMetadataRetriever;
    private MediaExtractor mMediaExtractor;
    private MediaCodec mMediaCodec;
    private int mTrackIndex;
    private long mDuration;
    private int mBitRate;
    private MediaCodec.BufferInfo mBufferInfo;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private long mStartTime;
    private long presentationTimeUs;
    private long mRequestTime = -1L;
    protected int mState = 0;
    private final Runnable mPlaybackTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object;
            MediaDecoder.this.mInputDone = (MediaDecoder.this.mOutputDone = false);
            MediaDecoder.this.mIsRunning = true;
            MediaDecoder.this.callOnStart();
            while (!MediaDecoder.this.mInputDone || !MediaDecoder.this.mOutputDone) {
                try {
                    if (MediaDecoder.this.mRequestTime >= 0L) {
                        MediaDecoder.this.handleSeek(MediaDecoder.this.mRequestTime);
                    }
                    if (!MediaDecoder.this.mInputDone) {
                        MediaDecoder.this.internal_HandleInput();
                    }
                    if (!MediaDecoder.this.mOutputDone) {
                        MediaDecoder.this.internal_handleOutput();
                    }
                    if (MediaDecoder.this.mIsRunning && (!MediaDecoder.this.mInputDone || !MediaDecoder.this.mOutputDone)) continue;
                    MediaDecoder.this.mState = 5;
                    MediaDecoder.this.callOnStop();
                    if (!MediaDecoder.this.mIsRunning) break;
                    MediaDecoder.this.mMediaCodec.flush();
                    object = MediaDecoder.this.mSync;
                    synchronized (object) {
                        if (MediaDecoder.this.mState == 5) {
                            try {
                                MediaDecoder.this.mSync.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!MediaDecoder.this.mIsRunning) break;
                    MediaDecoder.this.callOnStart();
                    MediaDecoder.this.mStartTime = (MediaDecoder.this.presentationTimeUs = -1L);
                    MediaDecoder.this.mInputDone = (MediaDecoder.this.mOutputDone = false);
                    MediaDecoder.this.mState = 3;
                }
                catch (Exception e) {
                    Log.e((String)MediaDecoder.this.TAG, (String)"PlaybackTask:", (Throwable)e);
                    MediaDecoder.this.callErrorHandler(e);
                    break;
                }
            }
            MediaDecoder.this.internal_stop();
            object = MediaDecoder.this.mSync;
            synchronized (object) {
                MediaDecoder.this.mSync.notifyAll();
            }
        }
    };

    public void setCallback(IMediaCodecCallback callback) {
        this.mCallback = callback;
    }

    public IMediaCodecCallback getCallback() {
        return this.mCallback;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public int getBitRate() {
        return this.mBitRate;
    }

    public void setDataSource(String path) throws IOException {
        block2: {
            this.release();
            try {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(path);
                this.updateMovieInfo(this.mMediaMetadataRetriever);
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(path);
                this.mState = 1;
            }
            catch (IOException e) {
                this.internal_release();
                if (this.callErrorHandler(e)) break block2;
                throw e;
            }
        }
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException {
        block2: {
            this.release();
            try {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(path, headers);
                this.updateMovieInfo(this.mMediaMetadataRetriever);
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(path, headers);
                this.mState = 1;
            }
            catch (IOException e) {
                this.internal_release();
                if (this.callErrorHandler(e)) break block2;
                throw e;
            }
        }
    }

    public void setDataSource(FileDescriptor fd) throws IOException {
        block2: {
            this.release();
            try {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(fd);
                this.updateMovieInfo(this.mMediaMetadataRetriever);
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(fd);
                this.mState = 1;
            }
            catch (IOException e) {
                this.internal_release();
                if (this.callErrorHandler(e)) break block2;
                throw e;
            }
        }
    }

    public void setDataSource(FileDescriptor fd, long offset, long length) throws IOException {
        block2: {
            this.release();
            try {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(fd, offset, length);
                this.updateMovieInfo(this.mMediaMetadataRetriever);
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(fd, offset, length);
                this.mState = 1;
            }
            catch (IOException e) {
                this.internal_release();
                if (this.callErrorHandler(e)) break block2;
                throw e;
            }
        }
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException {
        block2: {
            this.release();
            try {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(context, uri);
                this.updateMovieInfo(this.mMediaMetadataRetriever);
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(context, uri, headers);
                this.mState = 1;
            }
            catch (IOException e) {
                this.internal_release();
                if (this.callErrorHandler(e)) break block2;
                throw e;
            }
        }
    }

    public void setDataSource(Context context, Uri uri) throws IOException {
        block2: {
            this.release();
            this.mMediaMetadataRetriever = new MediaMetadataRetriever();
            try {
                this.mMediaMetadataRetriever.setDataSource(context, uri);
                this.updateMovieInfo(this.mMediaMetadataRetriever);
                this.mMediaExtractor = new MediaExtractor();
                this.mMediaExtractor.setDataSource(context, uri, null);
                this.mState = 1;
            }
            catch (IOException e) {
                this.release();
                if (this.callErrorHandler(e)) break block2;
                throw e;
            }
        }
    }

    @Override
    public void prepare() throws IOException {
        block9: {
            if (this.mMediaExtractor == null) {
                IllegalStateException e = new IllegalStateException("DataSource not set yet");
                if (!this.callErrorHandler(e)) {
                    throw e;
                }
                return;
            }
            if (this.mState != 1) {
                IllegalStateException e = new IllegalStateException("already prepared");
                if (!this.callErrorHandler(e)) {
                    throw e;
                }
                return;
            }
            try {
                this.mTrackIndex = this.handlePrepare(this.mMediaExtractor);
                if (this.mTrackIndex < 0) {
                    throw new IOException("track not found");
                }
                this.mMediaExtractor.selectTrack(this.mTrackIndex);
                MediaFormat format = this.mMediaExtractor.getTrackFormat(this.mTrackIndex);
                this.mDuration = format.getLong("durationUs");
                this.mMediaCodec = this.createCodec(this.mMediaExtractor, this.mTrackIndex, format);
            }
            catch (Exception e) {
                if (this.mMediaExtractor != null) {
                    this.mMediaExtractor.release();
                    this.mMediaExtractor = null;
                }
                if (this.callErrorHandler(e)) break block9;
                throw e;
            }
        }
        if (this.mTrackIndex >= 0 && this.mMediaCodec != null) {
            this.mState = 2;
            this.callOnPrepared();
        }
    }

    @Override
    public boolean isPrepared() {
        return this.mState >= 2;
    }

    @Override
    public boolean isRunning() {
        return this.mState == 3;
    }

    protected abstract int handlePrepare(MediaExtractor var1);

    protected abstract Surface getOutputSurface();

    protected MediaCodec createCodec(MediaExtractor media_extractor, int track_index, MediaFormat format) throws IOException {
        MediaCodec codec = null;
        if (track_index >= 0) {
            String mime = format.getString("mime");
            codec = MediaCodec.createDecoderByType((String)mime);
            codec.configure(format, this.getOutputSurface(), null, 0);
            codec.start();
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        if (this.mState == 5) {
            Object object = this.mSync;
            synchronized (object) {
                this.mMediaExtractor.unselectTrack(this.mTrackIndex);
                this.mMediaExtractor.selectTrack(this.mTrackIndex);
                this.mState = 3;
                this.mSync.notifyAll();
            }
        }
    }

    @Override
    public void start() {
        boolean needRestart = true;
        switch (this.mState) {
            case 3: {
                return;
            }
            case 4: {
                needRestart = false;
            }
            case 2: {
                this.mState = 3;
                break;
            }
            default: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
        }
        if (needRestart) {
            this.presentationTimeUs = -1L;
            this.mBufferInfo = new MediaCodec.BufferInfo();
            this.mInputBuffers = this.mMediaCodec.getInputBuffers();
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            new Thread(this.mPlaybackTask, this.TAG).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            this.mIsRunning = false;
            if (this.mState >= 3) {
                this.mSync.notifyAll();
                try {
                    this.mSync.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private final void internal_stop() {
        switch (this.mState) {
            case 3: 
            case 4: 
            case 5: {
                if (this.mMediaCodec != null) {
                    this.mMediaCodec.stop();
                }
                this.mState = 2;
            }
        }
    }

    public void pause() {
        switch (this.mState) {
            case 3: 
            case 4: 
            case 5: {
                this.mState = 4;
                break;
            }
            default: {
                IllegalStateException e = new IllegalStateException();
                if (this.callErrorHandler(e)) break;
                throw e;
            }
        }
    }

    @Override
    public void release() {
        if (this.mState != 0) {
            this.stop();
            this.mState = 0;
            this.callOnRelease();
        }
        this.internal_release();
    }

    private void internal_release() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
        }
        if (this.mMediaExtractor != null) {
            this.mMediaExtractor.release();
            this.mMediaExtractor = null;
        }
        if (this.mMediaMetadataRetriever != null) {
            this.mMediaMetadataRetriever.release();
            this.mMediaMetadataRetriever = null;
        }
        this.mTrackIndex = -1;
        this.mDuration = 0L;
        this.mBitRate = 0;
    }

    public void seek(long newTime) {
        this.mRequestTime = newTime;
    }

    private final void handleSeek(long newTime) {
        if (newTime < 0L) {
            return;
        }
        if (this.mMediaExtractor != null) {
            this.mMediaExtractor.seekTo(newTime, 0);
            this.mMediaExtractor.advance();
        }
        this.mRequestTime = -1L;
    }

    protected void internal_HandleInput() {
        int inputBufIndex;
        boolean b = false;
        if (!this.mInputDone) {
            if (this.presentationTimeUs < 0L) {
                this.presentationTimeUs = this.mMediaExtractor.getSampleTime();
            }
            if (this.presentationTimeUs >= 0L) {
                this.presentationTimeUs = this.handleInput(this.presentationTimeUs);
                b = true;
            }
        }
        if (!b && (inputBufIndex = this.mMediaCodec.dequeueInputBuffer(10000L)) >= 0) {
            this.mMediaCodec.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
            this.mInputDone = true;
        }
    }

    protected long handleInput(long presentationTimeUs) {
        long result = presentationTimeUs;
        int inputBufIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
        if (inputBufIndex >= 0) {
            int size = this.mMediaExtractor.readSampleData(this.mInputBuffers[inputBufIndex], 0);
            if (size > 0) {
                this.mMediaCodec.queueInputBuffer(inputBufIndex, 0, size, presentationTimeUs, 0);
            }
            this.mMediaExtractor.advance();
            result = -1L;
        }
        return result;
    }

    protected void internal_handleOutput() {
        int decoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
        if (decoderStatus == -1) {
            return;
        }
        if (decoderStatus == -3) {
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
        } else if (decoderStatus == -2) {
            MediaFormat mediaFormat = this.mMediaCodec.getOutputFormat();
        } else if (decoderStatus < 0) {
            RuntimeException e = new RuntimeException("unexpected result from dequeueOutputBuffer: " + decoderStatus);
            if (!this.callErrorHandler(e)) {
                throw e;
            }
        } else {
            boolean doRender = false;
            if (this.mBufferInfo.size > 0) {
                boolean bl = doRender = !this.handleOutput(this.mOutputBuffers[decoderStatus], 0, this.mBufferInfo.size, this.mBufferInfo.presentationTimeUs);
                if (doRender && (this.mCallback == null || !this.mCallback.onFrameAvailable(this, this.mBufferInfo.presentationTimeUs))) {
                    this.mStartTime = this.adjustPresentationTime(this.mStartTime, this.mBufferInfo.presentationTimeUs);
                }
            }
            this.mMediaCodec.releaseOutputBuffer(decoderStatus, doRender);
            if ((this.mBufferInfo.flags & 4) != 0) {
                this.mOutputDone = true;
            }
        }
    }

    protected abstract boolean handleOutput(ByteBuffer var1, int var2, int var3, long var4);

    protected boolean callErrorHandler(Exception e) {
        if (this.mCallback != null) {
            return this.mCallback.onError(this, e);
        }
        return false;
    }

    protected void callOnPrepared() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onPrepared(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnPrepared", (Throwable)e);
            }
        }
    }

    protected void callOnStart() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onStart(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnStart", (Throwable)e);
            }
        }
    }

    protected void callOnStop() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onStop(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnStop", (Throwable)e);
            }
        }
    }

    protected void callOnRelease() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onRelease(this);
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (String)"callOnRelease", (Throwable)e);
            }
        }
    }

    protected void updateMovieInfo(MediaMetadataRetriever metadata) {
        this.mBitRate = 0;
        String value = metadata.extractMetadata(20);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.mBitRate = Integer.parseInt(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long adjustPresentationTime(long startTime, long presentationTimeUs) {
        if (BuildCheck.isJellyBeanMr1()) {
            return this.adjustPresentationTimeAPI17(startTime, presentationTimeUs);
        }
        if (startTime > 0L) {
            long t = presentationTimeUs - (Time.nanoTime() / 1000L - startTime);
            while (t > 0L) {
                Object object = this.mSync;
                synchronized (object) {
                    try {
                        this.mSync.wait(t / 1000L, (int)(t % 1000L * 1000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.mIsRunning) {
                        break;
                    }
                }
                t = presentationTimeUs - (Time.nanoTime() / 1000L - startTime);
            }
            return startTime;
        }
        return Time.nanoTime() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    protected long adjustPresentationTimeAPI17(long startTime, long presentationTimeUs) {
        if (startTime > 0L) {
            long t = presentationTimeUs - (Time.nanoTime() / 1000L - startTime);
            while (t > 0L) {
                Object object = this.mSync;
                synchronized (object) {
                    try {
                        this.mSync.wait(t / 1000L, (int)(t % 1000L * 1000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.mIsRunning) {
                        break;
                    }
                }
                t = presentationTimeUs - (Time.nanoTime() / 1000L - startTime);
            }
            return startTime;
        }
        return Time.nanoTime() / 1000L;
    }

    protected static final int selectTrack(MediaExtractor extractor, String mimeType) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!mime.startsWith(mimeType)) continue;
            return i;
        }
        return -1;
    }
}

