/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.MediaDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaAudioDecoder
extends MediaDecoder {
    private static final boolean DEBUG = false;
    private int mAudioChannels;
    private int mAudioSampleRate;
    private int mAudioInputBufSize;
    private byte[] mAudioOutTempBuf;
    private AudioTrack mAudioTrack;

    @Override
    @TargetApi(value=16)
    protected int handlePrepare(MediaExtractor media_extractor) {
        int track_index = MediaAudioDecoder.selectTrack(media_extractor, "audio/");
        if (track_index >= 0) {
            MediaFormat format = media_extractor.getTrackFormat(track_index);
            this.mAudioChannels = format.getInteger("channel-count");
            this.mAudioSampleRate = format.getInteger("sample-rate");
            int min_buf_size = AudioTrack.getMinBufferSize((int)this.mAudioSampleRate, (int)(this.mAudioChannels == 1 ? 4 : 12), (int)2);
            int max_input_size = format.getInteger("max-input-size");
            int n = this.mAudioInputBufSize = min_buf_size > 0 ? min_buf_size * this.mAudioChannels * 2 : max_input_size;
            if (this.mAudioInputBufSize > max_input_size) {
                this.mAudioInputBufSize = max_input_size;
            }
            int frameSizeInBytes = this.mAudioChannels * 2;
            this.mAudioInputBufSize = this.mAudioInputBufSize / frameSizeInBytes * frameSizeInBytes;
        }
        return track_index;
    }

    @Override
    protected MediaCodec createCodec(MediaExtractor media_extractor, int track_index, MediaFormat format) throws IOException, IllegalArgumentException {
        MediaCodec codec = super.createCodec(media_extractor, track_index, format);
        if (codec != null) {
            ByteBuffer[] buffers = codec.getOutputBuffers();
            int sz = buffers[0].capacity();
            if (sz <= 0) {
                sz = this.mAudioInputBufSize;
            }
            this.mAudioOutTempBuf = new byte[sz];
            try {
                this.mAudioTrack = new AudioTrack(3, this.mAudioSampleRate, this.mAudioChannels == 1 ? 4 : 12, 2, this.mAudioInputBufSize, 1);
                this.mAudioTrack.play();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"failed to start audio track playing", (Throwable)e);
                if (this.mAudioTrack != null) {
                    this.mAudioTrack.release();
                    this.mAudioTrack = null;
                }
                throw e;
            }
        }
        return codec;
    }

    @Override
    protected Surface getOutputSurface() {
        return null;
    }

    @Override
    protected boolean handleOutput(ByteBuffer buffer, int offset, int size, long presentationTimeUs) {
        if (this.mAudioOutTempBuf.length < size) {
            this.mAudioOutTempBuf = new byte[size];
        }
        buffer.position(offset);
        buffer.get(this.mAudioOutTempBuf, 0, size);
        buffer.clear();
        if (this.mAudioTrack != null) {
            this.mAudioTrack.write(this.mAudioOutTempBuf, 0, size);
        }
        return true;
    }
}

