/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IAudioEncoder;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public abstract class AbstractAudioEncoder
extends AbstractEncoder
implements IAudioEncoder {
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BIT_RATE = 64000;
    public static final int SAMPLES_PER_FRAME = 1024;
    public static final int FRAMES_PER_BUFFER = 25;
    protected int mAudioSource;
    protected int mChannelCount;
    protected int mSampleRate;
    protected int mBitRate;

    public AbstractAudioEncoder(IRecorder recorder, EncoderListener listener, int audio_source, int audio_channels) {
        this(recorder, listener, audio_source, audio_channels, 44100, 64000);
    }

    public AbstractAudioEncoder(IRecorder recorder, EncoderListener listener, int audio_source, int audio_channels, int sample_rate, int bit_rate) {
        super("audio/mp4a-latm", recorder, listener);
        this.mAudioSource = audio_source;
        this.mChannelCount = audio_channels;
        this.mSampleRate = sample_rate;
        this.mBitRate = bit_rate;
    }

    @Override
    protected boolean internalPrepare() throws Exception {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mRecorderStarted = false;
        MediaCodecInfo audioCodecInfo = MediaCodecHelper.selectAudioEncoder(this.MIME_TYPE);
        if (audioCodecInfo == null) {
            return true;
        }
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", this.mChannelCount == 1 ? 16 : 12);
        audioFormat.setInteger("bitrate", this.mBitRate);
        audioFormat.setInteger("channel-count", this.mChannelCount);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)this.MIME_TYPE);
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        return false;
    }

    @Override
    public final boolean isAudio() {
        return true;
    }

    @Override
    protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1, int ix2) {
        if (ix0 >= 0) {
            // empty if block
        }
        MediaFormat outFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        ByteBuffer csd0 = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        csd0.put(csd, 0, size);
        csd0.flip();
        outFormat.setByteBuffer("csd-0", csd0);
        return outFormat;
    }
}

