/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.opengl.GLES20;
import android.view.MotionEvent;
import com.serenegiant.glutils.GLHelper;
import com.serenegiant.glutils.ShaderConst;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class Texture2dProgram {
    private static final boolean DEBUG = false;
    private static final String TAG = "Texture2dProgram";
    private final Object mSync = new Object();
    private final ProgramType mProgramType;
    private float mTexWidth;
    private float mTexHeight;
    private int mProgramHandle;
    private final int muMVPMatrixLoc;
    private final int muTexMatrixLoc;
    private final int maPositionLoc;
    private final int maTextureCoordLoc;
    private int muKernelLoc;
    private int muTexOffsetLoc;
    private int muColorAdjustLoc;
    private int muTouchPositionLoc;
    private int muFlagsLoc;
    private int mTextureTarget;
    protected boolean mHasKernel2;
    private final float[] mKernel = new float[18];
    private final float[] mSummedTouchPosition = new float[2];
    private final float[] mLastTouchPosition = new float[2];
    private float[] mTexOffset;
    private float mColorAdjust;
    private final int[] mFlags = new int[4];

    public Texture2dProgram(int target, String fss) {
        this(ProgramType.TEXTURE_CUSTOM, target, "#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", fss);
    }

    public Texture2dProgram(int target, String vss, String fss) {
        this(ProgramType.TEXTURE_CUSTOM, target, vss, fss);
    }

    public Texture2dProgram(ProgramType programType) {
        this(programType, 0, null, null);
    }

    protected Texture2dProgram(ProgramType programType, int target, String vss, String fss) {
        this.mProgramType = programType;
        float[] kernel = null;
        float[] kernel2 = null;
        switch (programType) {
            case TEXTURE_2D: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_2D);
                break;
            }
            case TEXTURE_FILT3x3: {
                this.mTextureTarget = 3553;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_FILT3x3);
                break;
            }
            case TEXTURE_EXT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_EXT);
                break;
            }
            case TEXTURE_EXT_BW: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_EXT_BW);
                break;
            }
            case TEXTURE_EXT_NIGHT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_EXT_NIGHT);
                break;
            }
            case TEXTURE_EXT_CHROMA_KEY: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_EXT_CHROMA_KEY);
                break;
            }
            case TEXTURE_EXT_SQUEEZE: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_EXT_SQUEEZE);
                break;
            }
            case TEXTURE_EXT_TWIRL: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    float r = length(normCoord); // to polar coords \n    float phi = atan(normCoord.y + uPosition.y, normCoord.x + uPosition.x); // to polar coords \n    phi = phi + (1.0 - smoothstep(-0.5, 0.5, r)) * 4.0;\n    normCoord.x = r * cos(phi); \n    normCoord.y = r * sin(phi); \n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_TUNNEL: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    float r = length(normCoord); // to polar coords \n    float phi = atan(normCoord.y + uPosition.y, normCoord.x + uPosition.x); // to polar coords \n    if (r > 0.5) r = 0.5;\n    normCoord.x = r * cos(phi); \n    normCoord.y = r * sin(phi); \n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_BULGE: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    float r = length(normCoord); // to polar coords \n    float phi = atan(normCoord.y + uPosition.y, normCoord.x + uPosition.x); // to polar coords \n    r = r * smoothstep(-0.1, 0.5, r);\n    normCoord.x = r * cos(phi); \n    normCoord.y = r * sin(phi); \n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_FISHEYE: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    float r = length(normCoord); // to polar coords \n    float phi = atan(normCoord.y + uPosition.y, normCoord.x + uPosition.x); // to polar coords \n    r = r * r / sqrt(2.0);\n    normCoord.x = r * cos(phi); \n    normCoord.y = r * sin(phi); \n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_DENT: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    float r = length(normCoord); // to polar coords \n    float phi = atan(normCoord.y + uPosition.y, normCoord.x + uPosition.x); // to polar coords \n    r = 2.0 * r - r * smoothstep(0.0, 0.7, r);\n    normCoord.x = r * cos(phi); \n    normCoord.y = r * sin(phi); \n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_MIRROR: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    normCoord.x = normCoord.x * sign(normCoord.x + uPosition.x);\n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_STRETCH: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", "#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform vec2 uPosition;\nvoid main() {\n    vec2 texCoord = vTextureCoord.xy;\n    vec2 normCoord = 2.0 * texCoord - 1.0;\n    vec2 s = sign(normCoord + uPosition);\n    normCoord = abs(normCoord);\n    normCoord = 0.5 * normCoord + 0.5 * smoothstep(0.25, 0.5, normCoord) * normCoord;\n    normCoord = s * normCoord;\n    texCoord = normCoord / 2.0 + 0.5;\n    gl_FragColor = texture2D(sTexture, texCoord);\n}\n");
                break;
            }
            case TEXTURE_EXT_FILT3x3: {
                this.mTextureTarget = 36197;
                this.mProgramHandle = GLHelper.loadShader("#version 100\nuniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n", ShaderConst.FRAGMENT_SHADER_EXT_FILT3x3);
                break;
            }
            case TEXTURE_CUSTOM: {
                switch (target) {
                    case 3553: 
                    case 36197: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("target should be GL_TEXTURE_2D or GL_TEXTURE_EXTERNAL_OES");
                    }
                }
                this.mTextureTarget = target;
                this.mProgramHandle = GLHelper.loadShader(vss, fss);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled type " + (Object)((Object)programType));
            }
        }
        if (this.mProgramHandle == 0) {
            throw new RuntimeException("Unable to create program");
        }
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        GLHelper.checkLocation(this.maPositionLoc, "aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        GLHelper.checkLocation(this.maTextureCoordLoc, "aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        GLHelper.checkLocation(this.muMVPMatrixLoc, "uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
        this.initLocation(kernel, kernel2);
    }

    public void release() {
        GLES20.glDeleteProgram((int)this.mProgramHandle);
        this.mProgramHandle = -1;
    }

    public ProgramType getProgramType() {
        return this.mProgramType;
    }

    public int getProgramHandle() {
        return this.mProgramHandle;
    }

    public int createTextureObject() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLHelper.checkGlError("glGenTextures");
        int texId = textures[0];
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        GLHelper.checkGlError("glBindTexture " + texId);
        GLES20.glTexParameterf((int)this.mTextureTarget, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)this.mTextureTarget, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)this.mTextureTarget, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)this.mTextureTarget, (int)10243, (int)33071);
        GLHelper.checkGlError("glTexParameter");
        return texId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTouchEvent(MotionEvent ev) {
        Object object = this.mSync;
        synchronized (object) {
            if (ev.getAction() == 2) {
                if (this.mTexHeight != 0.0f && this.mTexWidth != 0.0f) {
                    this.mSummedTouchPosition[0] = this.mSummedTouchPosition[0] + 2.0f * (ev.getX() - this.mLastTouchPosition[0]) / this.mTexWidth;
                    this.mSummedTouchPosition[1] = this.mSummedTouchPosition[1] + 2.0f * (ev.getY() - this.mLastTouchPosition[1]) / -this.mTexHeight;
                    this.mLastTouchPosition[0] = ev.getX();
                    this.mLastTouchPosition[1] = ev.getY();
                }
            } else if (ev.getAction() == 0) {
                this.mLastTouchPosition[0] = ev.getX();
                this.mLastTouchPosition[1] = ev.getY();
            }
        }
    }

    public void setKernel(float[] values, float colorAdj) {
        if (values.length < 9) {
            throw new IllegalArgumentException("Kernel size is " + values.length + " vs. " + 9);
        }
        System.arraycopy(values, 0, this.mKernel, 0, 9);
        this.mColorAdjust = colorAdj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKernel2(float[] values) {
        Object object = this.mSync;
        synchronized (object) {
            boolean bl = this.mHasKernel2 = values != null && values.length == 9;
            if (this.mHasKernel2) {
                System.arraycopy(values, 0, this.mKernel, 9, 9);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorAdjust(float adjust) {
        Object object = this.mSync;
        synchronized (object) {
            this.mColorAdjust = adjust;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTexSize(int width, int height) {
        this.mTexHeight = height;
        this.mTexWidth = width;
        float rw = 1.0f / (float)width;
        float rh = 1.0f / (float)height;
        Object object = this.mSync;
        synchronized (object) {
            this.mTexOffset = new float[]{-rw, -rh, 0.0f, -rh, rw, -rh, -rw, 0.0f, 0.0f, 0.0f, rw, 0.0f, -rw, rh, 0.0f, rh, rw, rh};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlags(int[] flags) {
        int n = Math.min(4, flags != null ? flags.length : 0);
        if (n > 0) {
            Object object = this.mSync;
            synchronized (object) {
                System.arraycopy(flags, 0, this.mFlags, 0, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlag(int index, int value) {
        if (index >= 0 && index < this.mFlags.length) {
            Object object = this.mSync;
            synchronized (object) {
                this.mFlags[index] = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(float[] mvpMatrix, int mvpMatrixOffset, FloatBuffer vertexBuffer, int firstVertex, int vertexCount, int coordsPerVertex, int vertexStride, float[] texMatrix, int texMatrixOffset, FloatBuffer texBuffer, int textureId, int texStride) {
        GLHelper.checkGlError("draw start");
        GLES20.glUseProgram((int)this.mProgramHandle);
        GLHelper.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)textureId);
        GLHelper.checkGlError("glBindTexture");
        Object object = this.mSync;
        synchronized (object) {
            GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])mvpMatrix, (int)mvpMatrixOffset);
            GLHelper.checkGlError("glUniformMatrix4fv");
            if (this.muTexMatrixLoc >= 0) {
                GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])texMatrix, (int)texMatrixOffset);
                GLHelper.checkGlError("glUniformMatrix4fv");
            }
            GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
            GLHelper.checkGlError("glEnableVertexAttribArray");
            GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)coordsPerVertex, (int)5126, (boolean)false, (int)vertexStride, (Buffer)vertexBuffer);
            GLHelper.checkGlError("glVertexAttribPointer");
            GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
            GLHelper.checkGlError("glEnableVertexAttribArray");
            GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)texStride, (Buffer)texBuffer);
            GLHelper.checkGlError("glVertexAttribPointer");
            if (this.muKernelLoc >= 0) {
                if (!this.mHasKernel2) {
                    GLES20.glUniform1fv((int)this.muKernelLoc, (int)9, (float[])this.mKernel, (int)0);
                } else {
                    GLES20.glUniform1fv((int)this.muKernelLoc, (int)18, (float[])this.mKernel, (int)0);
                }
                GLHelper.checkGlError("set kernel");
            }
            if (this.muTexOffsetLoc >= 0 && this.mTexOffset != null) {
                GLES20.glUniform2fv((int)this.muTexOffsetLoc, (int)9, (float[])this.mTexOffset, (int)0);
            }
            if (this.muColorAdjustLoc >= 0) {
                GLES20.glUniform1f((int)this.muColorAdjustLoc, (float)this.mColorAdjust);
            }
            if (this.muTouchPositionLoc >= 0) {
                GLES20.glUniform2fv((int)this.muTouchPositionLoc, (int)1, (float[])this.mSummedTouchPosition, (int)0);
            }
            if (this.muFlagsLoc >= 0) {
                GLES20.glUniform1iv((int)this.muFlagsLoc, (int)4, (int[])this.mFlags, (int)0);
            }
        }
        this.internal_draw(firstVertex, vertexCount);
        GLES20.glDisableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLoc);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }

    protected void initLocation(float[] kernel, float[] kernel2) {
        this.muKernelLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uKernel");
        if (this.muKernelLoc < 0) {
            this.muKernelLoc = -1;
            this.muTexOffsetLoc = -1;
        } else {
            this.muTexOffsetLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexOffset");
            if (this.muTexOffsetLoc < 0) {
                this.muTexOffsetLoc = -1;
            }
            if (kernel == null) {
                kernel = ShaderConst.KERNEL_NULL;
            }
            this.setKernel(kernel, 0.0f);
            this.setTexSize(256, 256);
        }
        if (kernel2 != null) {
            this.setKernel2(kernel2);
        }
        this.muColorAdjustLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uColorAdjust");
        if (this.muColorAdjustLoc < 0) {
            this.muColorAdjustLoc = -1;
        }
        this.muTouchPositionLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uPosition");
        if (this.muTouchPositionLoc < 0) {
            this.muTouchPositionLoc = -1;
        }
        this.muFlagsLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uFlags");
        if (this.muFlagsLoc < 0) {
            this.muFlagsLoc = -1;
        }
    }

    protected void internal_draw(int firstVertex, int vertexCount) {
        GLES20.glDrawArrays((int)5, (int)firstVertex, (int)vertexCount);
        GLHelper.checkGlError("glDrawArrays");
    }

    public static enum ProgramType {
        TEXTURE_2D,
        TEXTURE_FILT3x3,
        TEXTURE_CUSTOM,
        TEXTURE_EXT,
        TEXTURE_EXT_BW,
        TEXTURE_EXT_NIGHT,
        TEXTURE_EXT_CHROMA_KEY,
        TEXTURE_EXT_SQUEEZE,
        TEXTURE_EXT_TWIRL,
        TEXTURE_EXT_TUNNEL,
        TEXTURE_EXT_BULGE,
        TEXTURE_EXT_DENT,
        TEXTURE_EXT_FISHEYE,
        TEXTURE_EXT_STRETCH,
        TEXTURE_EXT_MIRROR,
        TEXTURE_EXT_FILT3x3;

    }
}

