/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.dialog;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.serenegiant.common.R;
import com.serenegiant.dialog.DialogFragmentEx;
import com.serenegiant.widget.ColorPickerView;

public class ColorPickerDialogV4
extends DialogFragmentEx {
    private static final boolean DEBUG = false;
    private static final String TAG = "ColorPickerDialog";
    private static final String KEY_COLOR_INIT = "initial_color";
    private static final String KEY_COLOR_CURRENT = "current_color";
    private static final int DEFAULT_COLOR = -1;
    private OnColorChangedListener mListener;
    private int mTitleResId;
    private int mInitialColor = -1;
    private int mCurrentColor = -1;
    private boolean isCanceled;
    private final ColorPickerView.ColorPickerListener mColorPickerListener = new ColorPickerView.ColorPickerListener(){

        @Override
        public void onColorChanged(ColorPickerView view, int color) {
            if (ColorPickerDialogV4.this.mCurrentColor != color) {
                ColorPickerDialogV4.this.mCurrentColor = color;
                if (ColorPickerDialogV4.this.mListener != null) {
                    ColorPickerDialogV4.this.mListener.onColorChanged(ColorPickerDialogV4.this, color);
                }
            }
        }
    };
    private final DialogInterface.OnClickListener mOnClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case -1: {
                    dialog.dismiss();
                    break;
                }
                case -2: {
                    dialog.cancel();
                }
            }
        }
    };

    public static ColorPickerDialogV4 show(@NonNull FragmentActivity parent, @StringRes int titleResId, int initialColor) {
        ColorPickerDialogV4 dialog = ColorPickerDialogV4.newInstance(titleResId, initialColor);
        dialog.show(parent.getSupportFragmentManager(), TAG);
        return dialog;
    }

    public static ColorPickerDialogV4 show(@NonNull Fragment parent, @StringRes int titleResId, int initialColor) {
        ColorPickerDialogV4 dialog = ColorPickerDialogV4.newInstance(titleResId, initialColor);
        dialog.setTargetFragment(parent, 0);
        dialog.show(parent.getFragmentManager(), TAG);
        return dialog;
    }

    public static ColorPickerDialogV4 newInstance(@StringRes int titleResId, int initialColor) {
        ColorPickerDialogV4 dialog = new ColorPickerDialogV4();
        dialog.setArguments(titleResId, initialColor);
        return dialog;
    }

    public void setArguments(@StringRes int titleResId, int initialColor) {
        Bundle args = this.getArguments();
        if (args == null) {
            args = new Bundle();
        }
        args.putInt("title", titleResId);
        args.putInt(KEY_COLOR_INIT, initialColor);
        args.remove(KEY_COLOR_CURRENT);
        this.setArguments(args);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.requireArguments();
        this.mTitleResId = args.getInt("title");
        this.mCurrentColor = this.mInitialColor = args.getInt(KEY_COLOR_INIT, -1);
        if (savedInstanceState != null) {
            this.mCurrentColor = savedInstanceState.getInt(KEY_COLOR_CURRENT, this.mInitialColor);
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(KEY_COLOR_CURRENT, this.mCurrentColor);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.isCanceled = false;
        try {
            this.mListener = (OnColorChangedListener)this.getTargetFragment();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.mListener == null) {
            try {
                this.mListener = (OnColorChangedListener)this.getParentFragment();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.mListener == null) {
            try {
                this.mListener = (OnColorChangedListener)context;
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.mListener == null) {
            Log.w((String)TAG, (String)"must implement OnColorChangedListener");
        }
    }

    @NonNull
    @SuppressLint(value={"InflateParams"})
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity activity = this.requireActivity();
        FrameLayout rootView = (FrameLayout)LayoutInflater.from((Context)activity).inflate(R.layout.color_picker, null);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        ColorPickerView view = new ColorPickerView((Context)activity);
        view.setColor(this.mCurrentColor);
        view.setColorPickerListener(this.mColorPickerListener);
        rootView.addView((View)view, (ViewGroup.LayoutParams)params);
        AlertDialog dialog = new AlertDialog.Builder((Context)activity).setPositiveButton(R.string.color_picker_select, this.mOnClickListener).setNegativeButton(R.string.color_picker_cancel, this.mOnClickListener).setTitle(this.mTitleResId != 0 ? this.mTitleResId : R.string.color_picker_default_title).setView((View)rootView).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.isCanceled = true;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mListener != null) {
            if (this.isCanceled) {
                this.mListener.onCancel(this);
            } else {
                this.mListener.onDismiss(this, this.mCurrentColor);
            }
        }
    }

    public static interface OnColorChangedListener {
        public void onColorChanged(ColorPickerDialogV4 var1, int var2);

        public void onCancel(ColorPickerDialogV4 var1);

        public void onDismiss(ColorPickerDialogV4 var1, int var2);
    }
}

