/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import HPRTAndroidSDK.IPort;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class WiFiOperator
implements IPort {
    private static String IPAddress = "";
    private static int intPort = 0;
    private static String PrinterName = "";
    private static String InPrinterName = "";
    private boolean blnOpenPort = false;
    private static Socket SocketC = null;
    private InputStream mmInStream;
    private OutputStream mmOutStream;
    private int ReadTimeout = 1000;
    private int intWR = 0;

    public WiFiOperator(Context context) {
        InPrinterName = "HPRT";
    }

    public WiFiOperator(Context context, String strPrinterName) {
        PrinterName = strPrinterName;
        InPrinterName = strPrinterName;
    }

    @Override
    public void IsBLEType(boolean isBLEType) {
    }

    @Override
    public void InitPort() {
    }

    @Override
    public void SetReadTimeout(int readTimeout) {
        this.ReadTimeout = readTimeout;
    }

    @Override
    public void SetWriteTimeout(int writeTimeout) {
    }

    @Override
    public boolean OpenPort(UsbDevice usbdevice) {
        return false;
    }

    @Override
    public boolean OpenPort(String PortParam) {
        return false;
    }

    @Override
    public boolean OpenPort(String PortParam, String PortNumber) {
        IPAddress = PortParam;
        intPort = Integer.parseInt(PortNumber);
        this.blnOpenPort = false;
        if (IPAddress.length() <= 0 || intPort <= 0) {
            return this.blnOpenPort;
        }
        new Thread(){

            @Override
            public void run() {
                super.run();
                try {
                    SocketC = new Socket(IPAddress, intPort);
                    SocketC.setSoTimeout(WiFiOperator.this.ReadTimeout);
                    WiFiOperator.this.mmInStream = SocketC.getInputStream();
                    WiFiOperator.this.mmOutStream = SocketC.getOutputStream();
                    WiFiOperator.this.blnOpenPort = true;
                    String data = "";
                    data = "SELFTEST\r\n";
                }
                catch (UnknownHostException e) {
                    Log.e((String)"WiFiOperator", (String)("OpenPort --> UNconnect " + e.getMessage()));
                    WiFiOperator.this.blnOpenPort = false;
                }
                catch (IOException e) {
                    Log.e((String)"WiFiOperator", (String)("OpenPort --> UNconnect " + e.getMessage()));
                    WiFiOperator.this.blnOpenPort = false;
                }
            }
        }.start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.blnOpenPort;
    }

    @Override
    public boolean ClosePort() {
        try {
            if (this.mmInStream != null) {
                this.mmInStream.close();
                this.mmInStream = null;
            }
            if (this.mmOutStream != null) {
                this.mmOutStream.close();
                this.mmOutStream = null;
            }
            if (SocketC != null) {
                SocketC.close();
                SocketC = null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int WriteData(byte[] Data) {
        return this.WriteData(Data, 0, Data.length);
    }

    @Override
    public int WriteData(byte[] Data, int intDataLength) {
        return this.WriteData(Data, 0, intDataLength);
    }

    @Override
    public int WriteData(byte[] Data, int intOffset, int intDataLength) {
        try {
            byte[] tmp = new byte[intDataLength];
            int i = 0;
            while (i < intDataLength) {
                tmp[i] = Data[intOffset + i];
                ++i;
            }
            this.mmOutStream.write(tmp, 0, intDataLength);
            this.mmOutStream.flush();
            return intDataLength;
        }
        catch (IOException e) {
            Log.d((String)"PRTLIB", (String)("WriteData --> error " + e.getMessage()));
            return -1;
        }
    }

    @Override
    public int ReadData(byte[] Data) {
        int intReadLen = 0;
        try {
            intReadLen = this.mmInStream.read(Data);
        }
        catch (IOException e) {
            return -1;
        }
        return intReadLen;
    }

    @Override
    public int ReadData(byte[] Data, int intOffset, int intLength) {
        int intReadLen = 0;
        try {
            intReadLen = this.mmInStream.read(Data, intOffset, intLength);
        }
        catch (IOException e) {
            return -1;
        }
        return intReadLen;
    }

    @Override
    public boolean IsOpen() {
        byte[] arrStatusCMD = new byte[]{29, 114, 1};
        byte[] arrRecStatus = new byte[1];
        this.intWR = this.WriteData(arrStatusCMD);
        if (this.intWR < 0) {
            this.blnOpenPort = false;
            return false;
        }
        this.intWR = this.ReadData(arrRecStatus, 0, 1);
        if (this.intWR < 0) {
            this.blnOpenPort = false;
            return false;
        }
        this.blnOpenPort = true;
        return this.blnOpenPort;
    }

    @Override
    public String GetPortType() {
        return "WiFi";
    }

    @Override
    public String GetPrinterName() {
        return PrinterName;
    }

    @Override
    public String GetPrinterModel() {
        return PrinterName;
    }
}

