/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import HPRTAndroidSDK.IPort;
import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.util.Log;
import android.widget.ArrayAdapter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class USBOperator
implements IPort {
    private UsbManager mUsbManager = null;
    private UsbDevice device = null;
    private UsbDeviceConnection connection = null;
    private PendingIntent mPermissionIntent = null;
    protected static final int STD_USB_REQUEST_GET_DESCRIPTOR = 6;
    protected static final int LIBUSB_DT_STRING = 3;
    private static final String ACTION_USB_PERMISSION = "com.android.example.PRTSDK";
    public ArrayAdapter<String> mUSBDevicesArrayAdapter;
    public int intPermissionState = 0;
    private static String PrinterName = "";
    private static String InPrinterName = "";
    private Context PreContext = null;
    public static List<String> PrinterList1 = new ArrayList<String>();
    public static List<String> PrinterList2 = new ArrayList<String>();
    private static boolean blnOpenPort = false;
    private UsbEndpoint inEndpoint = null;
    private UsbEndpoint outEndpoint = null;
    private int ReadTimeout = 1000;
    private int WriteTimeout = 1000;
    public Intent intent;
    private boolean DoPermissionYet = false;
    private BroadcastReceiver mUsbReceiver1 = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (USBOperator.ACTION_USB_PERMISSION.equals(action)) {
                if (USBOperator.this.DoPermissionYet) {
                    return;
                }
                1 var4_4 = this;
                synchronized (var4_4) {
                    USBOperator.this.device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (USBOperator.this.device != null) {
                            USBOperator.this.connection = null;
                            USBOperator.this.connection = USBOperator.this.mUsbManager.openDevice(USBOperator.this.device);
                            if (USBOperator.this.connection == null) {
                                blnOpenPort = false;
                                return;
                            }
                            try {
                                UsbInterface usbInterface = USBOperator.this.device.getInterface(0);
                                int i = 0;
                                while (i < usbInterface.getEndpointCount()) {
                                    UsbEndpoint ep = usbInterface.getEndpoint(i);
                                    if (7 == usbInterface.getInterfaceClass() && ep.getDirection() == 128) {
                                        USBOperator.this.outEndpoint = ep;
                                        if (usbInterface.getEndpointCount() == 1) {
                                            USBOperator.this.inEndpoint = ep;
                                        }
                                    }
                                    if (7 == usbInterface.getInterfaceClass() && ep.getDirection() == 0) {
                                        USBOperator.this.inEndpoint = ep;
                                        if (usbInterface.getEndpointCount() == 1) {
                                            USBOperator.this.outEndpoint = ep;
                                        }
                                    }
                                    ++i;
                                }
                                USBOperator.this.connection = USBOperator.this.mUsbManager.openDevice(USBOperator.this.device);
                                USBOperator.this.connection.claimInterface(usbInterface, true);
                            }
                            catch (Exception e) {
                                blnOpenPort = false;
                                return;
                            }
                            byte[] rawDescs = USBOperator.this.connection.getRawDescriptors();
                            try {
                                byte[] buffer = new byte[255];
                                byte idxPrd = rawDescs[15];
                                int rdo = USBOperator.this.connection.controlTransfer(128, 6, 0x300 | idxPrd, 0, buffer, 255, 0);
                                if (rdo > 2) {
                                    byte[] NewName = new byte[(rdo - 2) / 2];
                                    int intNewNameIdx = 0;
                                    int l = 2;
                                    while (l < rdo) {
                                        if (l % 2 == 0) {
                                            NewName[intNewNameIdx] = buffer[l];
                                            ++intNewNameIdx;
                                        }
                                        ++l;
                                    }
                                    PrinterName = new String(NewName, "ASCII");
                                } else {
                                    PrinterName = new String(buffer, 2, rdo, "ASCII");
                                }
                                PrinterName = PrinterName.trim();
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                blnOpenPort = true;
                                Log.d((String)"PRTLIB", (String)("OpenPort --> connect " + "Check Array Is Wrong!"));
                            }
                            catch (UnsupportedEncodingException e) {
                                e.getStackTrace();
                            }
                        }
                    } else {
                        blnOpenPort = false;
                        return;
                    }
                }
            }
            if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                USBOperator.this.device = (UsbDevice)intent.getParcelableExtra("device");
                if (USBOperator.this.device != null) {
                    USBOperator.this.ClosePort();
                }
            }
        }
    };

    public USBOperator(Context Context2) {
        this.PreContext = Context2;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.PreContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        this.PreContext.registerReceiver(this.mUsbReceiver1, filter);
        InPrinterName = "HPRT";
    }

    public USBOperator(Context Context2, String strPrintName) {
        this.PreContext = Context2;
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.PreContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
        this.PreContext.registerReceiver(this.mUsbReceiver1, filter);
        InPrinterName = strPrintName;
    }

    @Override
    public void IsBLEType(boolean isBLEType) {
    }

    @Override
    public boolean OpenPort(String PortParam, String PortNumber) {
        return false;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean OpenPort(String PortParam) {
        this.mUsbManager = (UsbManager)this.PreContext.getSystemService("usb");
        HashMap deviceList = this.mUsbManager.getDeviceList();
        for (UsbDevice this.device : deviceList.values()) {
            int count = this.device.getInterfaceCount();
            int i = 0;
            while (i < count) {
                UsbInterface intf = this.device.getInterface(i);
                if (intf.getInterfaceClass() == 7) {
                    this.mUsbManager.requestPermission(this.device, this.mPermissionIntent);
                    blnOpenPort = true;
                    return blnOpenPort;
                }
                ++i;
            }
        }
        blnOpenPort = false;
        return blnOpenPort;
    }

    @Override
    public boolean OpenPort(UsbDevice USBdevice) {
        block17: {
            try {
                this.mUsbManager = (UsbManager)this.PreContext.getSystemService("usb");
                this.DoPermissionYet = true;
                if (USBdevice != null) {
                    this.connection = null;
                    this.connection = this.mUsbManager.openDevice(USBdevice);
                    if (this.connection == null) {
                        blnOpenPort = false;
                        return blnOpenPort;
                    }
                    UsbInterface usbInterface = USBdevice.getInterface(0);
                    int i = 0;
                    while (i < usbInterface.getEndpointCount()) {
                        UsbEndpoint ep = usbInterface.getEndpoint(i);
                        if (7 == usbInterface.getInterfaceClass() && ep.getDirection() == 128) {
                            this.outEndpoint = ep;
                            if (usbInterface.getEndpointCount() == 1) {
                                this.inEndpoint = ep;
                            }
                        }
                        if (7 == usbInterface.getInterfaceClass() && ep.getDirection() == 0) {
                            this.inEndpoint = ep;
                            if (usbInterface.getEndpointCount() == 1) {
                                this.outEndpoint = ep;
                            }
                        }
                        ++i;
                    }
                    this.connection = this.mUsbManager.openDevice(USBdevice);
                    this.connection.claimInterface(usbInterface, true);
                    byte[] rawDescs = this.connection.getRawDescriptors();
                    try {
                        byte[] buffer = new byte[255];
                        byte idxPrd = rawDescs[15];
                        int rdo = this.connection.controlTransfer(128, 6, 0x300 | idxPrd, 0, buffer, 255, 0);
                        if (rdo > 2) {
                            byte[] NewName = new byte[(rdo - 2) / 2];
                            int intNewNameIdx = 0;
                            int l = 2;
                            while (l < rdo) {
                                if (l % 2 == 0) {
                                    NewName[intNewNameIdx] = buffer[l];
                                    ++intNewNameIdx;
                                }
                                ++l;
                            }
                            PrinterName = new String(NewName, "ASCII");
                        } else {
                            PrinterName = new String(buffer, 2, rdo, "ASCII");
                        }
                        PrinterName = PrinterName.trim();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        blnOpenPort = true;
                        Log.d((String)"PRTLIB", (String)("OpenPort --> connect " + "Check Array Is Wrong!"));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.getStackTrace();
                    }
                    break block17;
                }
                blnOpenPort = false;
            }
            catch (Exception e) {
                blnOpenPort = false;
                return blnOpenPort;
            }
        }
        return blnOpenPort;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean ClosePort() {
        if (this.device != null) {
            this.connection.close();
            this.connection = null;
            this.device = null;
            blnOpenPort = false;
        }
        return true;
    }

    @Override
    public void InitPort() {
    }

    @Override
    public void SetReadTimeout(int readTimeout) {
        this.ReadTimeout = readTimeout;
    }

    @Override
    public void SetWriteTimeout(int writeTimeout) {
        this.WriteTimeout = writeTimeout;
    }

    @Override
    public int WriteData(byte[] Data) {
        return this.WriteData(Data, 0, Data.length);
    }

    @Override
    public int WriteData(byte[] Data, int intDataLength) {
        return this.WriteData(Data, 0, intDataLength);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public int WriteData(byte[] Data, int intOffset, int intDataLength) {
        try {
            byte[] buffbyte = new byte[10000];
            int bytecount = intDataLength;
            int numb = bytecount / 10000;
            int i = 0;
            while (i < numb) {
                int j = i * 10000;
                while (j < (i + 1) * 10000) {
                    buffbyte[j % 10000] = Data[j];
                    ++j;
                }
                this.connection.bulkTransfer(this.inEndpoint, buffbyte, buffbyte.length, this.WriteTimeout);
                ++i;
            }
            if (bytecount % 10000 != 0) {
                byte[] buffend = new byte[Data.length - numb * 10000];
                int i2 = numb * 10000;
                while (i2 < Data.length) {
                    buffend[i2 - numb * 10000] = Data[i2];
                    ++i2;
                }
                this.connection.bulkTransfer(this.inEndpoint, buffend, buffend.length, this.WriteTimeout);
            }
            return intDataLength;
        }
        catch (Exception e) {
            Log.d((String)"PRTLIB", (String)("WriteData --> error " + e.getMessage()));
            return -1;
        }
    }

    @Override
    public int ReadData(byte[] Data) {
        try {
            int iLen = this.connection.bulkTransfer(this.outEndpoint, Data, Data.length, this.ReadTimeout);
            return iLen;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int ReadData(byte[] Data, int intOffset, int intLength) {
        try {
            int iLen = this.connection.bulkTransfer(this.outEndpoint, Data, Data.length, this.ReadTimeout);
            return iLen;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public boolean IsOpen() {
        return blnOpenPort;
    }

    @Override
    public String GetPortType() {
        return "USB";
    }

    @Override
    public String GetPrinterName() {
        return PrinterName;
    }

    @Override
    public String GetPrinterModel() {
        return PrinterName;
    }
}

