/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import android.app.AlertDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.net.wifi.WifiManager;
import android.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PublicFunction {
    private Context context = null;
    private List<String> PathDisplay = new ArrayList<String>();
    private List<String> PathTag = new ArrayList<String>();
    private ArrayList<HashMap<String, String>> PicList = new ArrayList();
    private String SDPath = "";
    public static final String PREFS_NAME = "MyPrefsFile";

    public PublicFunction() {
    }

    public PublicFunction(Context context) {
        this.context = context;
    }

    public String EnableDevice(String strDeviceType) {
        String strReturn = "";
        if (strDeviceType.equals("WiFi")) {
            strReturn = this.EnableWiFi();
        }
        if (strDeviceType.equals("Bluetooth")) {
            strReturn = this.EnableBluetooth();
        }
        return strReturn;
    }

    private String EnableWiFi() {
        try {
            if (this.context != null) {
                WifiManager wifiManager = (WifiManager)this.context.getSystemService("wifi");
                if (!wifiManager.isWifiEnabled()) {
                    wifiManager.setWifiEnabled(true);
                }
                return "OK";
            }
            return "Invalid Context";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String EnableBluetooth() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (!adapter.isEnabled()) {
                adapter.enable();
            }
            return "OK";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String DisableDevice(String strDeviceType) {
        String strReturn = "";
        if (strDeviceType.equals("WiFi")) {
            strReturn = this.DisableWiFi();
        }
        if (strDeviceType.equals("Bluetooth")) {
            strReturn = this.DisableBluetooth();
        }
        return strReturn;
    }

    private String DisableWiFi() {
        try {
            if (this.context != null) {
                WifiManager wifiManager = (WifiManager)this.context.getSystemService("wifi");
                if (wifiManager.isWifiEnabled()) {
                    wifiManager.setWifiEnabled(false);
                }
                return "OK";
            }
            return "Invalid Context";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String DisableBluetooth() {
        try {
            BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
            if (adapter.isEnabled()) {
                adapter.disable();
            }
            return "OK";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public void ShowMessageDialog(String strTitleText, String strMessage) {
        try {
            AlertDialog alertDialog = new AlertDialog.Builder(this.context).setTitle((CharSequence)strTitleText).setMessage((CharSequence)strMessage).setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).create();
            alertDialog.show();
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public void WriteSharedPreferencesData(String strName, String strValue) {
        SharedPreferences AppSetting = this.context.getSharedPreferences(PREFS_NAME, 0);
        AppSetting.edit().putString(strName, strValue).commit();
    }

    public String ReadSharedPreferencesData(String strName) {
        String strReturnValue = "";
        SharedPreferences AppSetting = this.context.getSharedPreferences(PREFS_NAME, 0);
        strReturnValue = AppSetting.getString(strName, "");
        return strReturnValue;
    }

    public int CountSubString(String strSource, String strFind) {
        int intCount = 0;
        int intCurPosi = 0;
        intCurPosi = strSource.indexOf(strFind);
        while (intCurPosi != -1) {
            ++intCurPosi;
            intCurPosi = strSource.indexOf(strFind, intCurPosi + 1);
        }
        return intCount;
    }

    public int GetStringIndex(String strSource, String strFind, int intFindTime, boolean blnNoStringReturnLenth) {
        int intIndex = -1;
        int i = 0;
        while (i < intFindTime) {
            if ((intIndex = strSource.indexOf(strFind, intIndex + 1)) == -1) break;
            ++i;
        }
        if (intIndex == -1) {
            if (blnNoStringReturnLenth) {
                return strSource.length();
            }
            return -1;
        }
        return intIndex;
    }

    public String CreateRepeatString(String strRepeat, int intRepeatTimes) {
        String strReturn = "";
        int i = 0;
        while (i < intRepeatTimes) {
            strReturn = String.valueOf(strReturn) + strRepeat;
            ++i;
        }
        return strReturn;
    }

    public String ReverseString(String strIn) {
        String strReturn = "";
        if (strIn.length() > 0) {
            int i = strIn.length();
            while (i > 0) {
                strReturn = String.valueOf(strReturn) + strIn.substring(i - 1, i);
                --i;
            }
        }
        return strReturn;
    }

    public String ReadTxtFile(String strFilePath) {
        File file;
        String strPath = strFilePath;
        String strContent = "";
        if (strPath.substring(0, 7).equals("file://")) {
            strPath = strPath.substring(7);
        }
        if (!(file = new File(strPath)).exists()) {
            return "false";
        }
        if (file.isDirectory()) {
            strContent = "false";
        } else {
            try {
                FileInputStream instream = new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    while ((line = buffreader.readLine()) != null) {
                        strContent = String.valueOf(strContent) + line + "\n";
                    }
                    if (-17 == strContent.substring(0, 1).getBytes()[0]) {
                        strContent = strContent.substring(1);
                    }
                    ((InputStream)instream).close();
                }
            }
            catch (FileNotFoundException e) {
                return "false";
            }
            catch (IOException e) {
                return "false";
            }
        }
        return strContent;
    }

    public static boolean ExistSDCard() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public ArrayList<HashMap<String, String>> GetSDPicture() {
        try {
            this.PicList.clear();
            this.PathDisplay.clear();
            this.PathTag.clear();
            if (PublicFunction.ExistSDCard()) {
                File path = Environment.getExternalStorageDirectory();
                this.SDPath = path.getAbsolutePath();
                this.HavePicture(path);
                Collections.sort(this.PathDisplay, String.CASE_INSENSITIVE_ORDER);
                Collections.sort(this.PathTag, String.CASE_INSENSITIVE_ORDER);
                int i = 0;
                while (i < this.PathTag.size()) {
                    HashMap<String, String> hash = new HashMap<String, String>();
                    hash.put("PathDisplay", this.PathDisplay.get(i));
                    hash.put("PathTag", this.PathTag.get(i));
                    this.PicList.add(hash);
                    ++i;
                }
                return this.PicList;
            }
            return null;
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean HavePicture(File InputFile) {
        try {
            File f;
            File[] SubFile;
            File[] fileArray = SubFile = InputFile.listFiles();
            int n = SubFile.length;
            int n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                if (f.isDirectory() && !f.getName().subSequence(0, 1).equals(".") && this.HavePicture(f)) {
                    this.PathDisplay.add(f.getAbsolutePath().replace(this.SDPath, ""));
                    this.PathTag.add(f.getAbsolutePath());
                }
                ++n2;
            }
            fileArray = SubFile;
            n = SubFile.length;
            n2 = 0;
            while (n2 < n) {
                f = fileArray[n2];
                if (!f.isDirectory() && this.IsPicture(f)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        catch (Exception e) {
            e.getStackTrace();
            return false;
        }
    }

    private boolean IsPicture(File InputFile) {
        int idx;
        String filename;
        block3: {
            filename = InputFile.getName();
            try {
                idx = filename.lastIndexOf(".");
                if (idx > 0) break block3;
                return false;
            }
            catch (Exception ex) {
                ex.getMessage();
                return false;
            }
        }
        String suffix = filename.substring(idx + 1, filename.length());
        return suffix.toLowerCase().equals("jpg") || suffix.toLowerCase().equals("jpeg") || suffix.toLowerCase().equals("bmp") || suffix.toLowerCase().equals("png") || suffix.toLowerCase().equals(".gif");
    }

    public byte[] sysCopy(List<byte[]> srcArrays) {
        int len = 0;
        for (byte[] srcArray : srcArrays) {
            len += srcArray.length;
        }
        byte[] destArray = new byte[len];
        int destLen = 0;
        for (byte[] srcArray : srcArrays) {
            System.arraycopy(srcArray, 0, destArray, destLen, srcArray.length);
            destLen += srcArray.length;
        }
        return destArray;
    }

    public byte[] ArrayCopy(byte[] A, int APos, byte[] B, int BPos, int Length) {
        byte[] Data = new byte[APos + Length - BPos];
        if (A != null) {
            System.arraycopy(A, 0, Data, 0, APos);
        }
        System.arraycopy(B, BPos, Data, APos, Length);
        return Data;
    }

    public int getCodePageIndex(String codePage) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Default", 0);
        map.put("Chinese Simplified", 0);
        map.put("Chinese Traditional", 0);
        map.put("PC437(USA:Standard Europe)", 0);
        map.put("KataKana", 1);
        map.put("PC850(Multilingual)", 2);
        map.put("PC860(Portuguese)", 3);
        map.put("PC863(Canadian-French)", 4);
        map.put("PC865(Nordic)", 5);
        map.put("PC857(Turkish)", 13);
        map.put("PC737(Greek)", 14);
        map.put("ISO8859-7(Greek)", 15);
        map.put("WCP1252", 16);
        map.put("PC866(Cyrillic #2)", 17);
        map.put("PC852(Latin 2)", 18);
        map.put("PC858(Euro)", 19);
        map.put("KU42", 20);
        map.put("TIS11(Thai)", 21);
        map.put("TIS18(Thai)", 26);
        map.put("PC720", 32);
        map.put("WPC775", 33);
        map.put("PC855(Cyrillic)", 33);
        map.put("PC862(Hebrew)", 36);
        map.put("PC864(Arabic)", 37);
        map.put("ISO8859-2(Latin2)", 39);
        map.put("ISO8859-15(Latin9)", 40);
        map.put("WPC1250", 45);
        map.put("WPC1251(Cyrillic)", 46);
        map.put("WPC1253", 47);
        map.put("WPC1254", 48);
        map.put("WPC1255", 49);
        map.put("WPC1256", 50);
        map.put("WPC1257", 51);
        map.put("WPC1258", 52);
        map.put("MIK(Cyrillic/Bulgarian)", 54);
        map.put("CP755(East Europe,Latvian 2)", 55);
        map.put("Iran", 56);
        map.put("Iran II", 57);
        map.put("Latvian", 58);
        map.put("ISO-8859-1(West Europe)", 59);
        map.put("ISO-8859-3(Latin 3)", 60);
        map.put("ISO-8859-4(Baltic)", 61);
        map.put("ISO-8859-5(Cyrillic)", 62);
        map.put("ISO-8859-6(Arabic)", 63);
        map.put("ISO-8859-8(Hebrew)", 64);
        map.put("ISO-8859-9(Turkish)", 65);
        map.put("PC856", 66);
        map.put("ABICOIM", 67);
        return (Integer)map.get(codePage);
    }

    public String getLanguageEncode(String codePage) {
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("Default", "gb2312");
        codeMap.put("Chinese Simplified", "gb2312");
        codeMap.put("Chinese Traditional", "big5");
        codeMap.put("PC437(USA:Standard Europe)", "iso8859-1");
        codeMap.put("KataKana", "Shift_JIS");
        codeMap.put("PC850(Multilingual)", "iso8859-3");
        codeMap.put("PC860(Portuguese)", "iso8859-6");
        codeMap.put("PC863(Canadian-French)", "iso8859-1");
        codeMap.put("PC865(Nordic)", "iso8859-1");
        codeMap.put("PC857(Turkish)", "iso8859-3");
        codeMap.put("PC737(Greek)", "iso8859-7");
        codeMap.put("ISO8859-7(Greek)", "iso8859-7");
        codeMap.put("WCP1252", "iso8859-1");
        codeMap.put("PC866(Cyrillic #2)", "iso8859-5");
        codeMap.put("PC852(Latin 2)", "iso8859-2");
        codeMap.put("PC858(Euro)", "iso8859-15");
        codeMap.put("KU42", "ISO8859-11");
        codeMap.put("TIS11(Thai)", "ISO8859-11");
        codeMap.put("TIS18(Thai)", "ISO8859-11");
        codeMap.put("PC720", "iso8859-6");
        codeMap.put("WPC775", "iso8859-1");
        codeMap.put("PC855(Cyrillic)", "iso8859-5");
        codeMap.put("PC862(Hebrew)", "iso8859-8");
        codeMap.put("PC864(Arabic)", "iso8859-6");
        codeMap.put("ISO8859-2(Latin2)", "iso8859-2");
        codeMap.put("ISO8859-15(Latin9)", "iso8859-15");
        codeMap.put("WPC1250", "iso8859-2");
        codeMap.put("WPC1251(Cyrillic)", "iso8859-5");
        codeMap.put("WPC1253", "iso8859-7");
        codeMap.put("WPC1254", "iso8859-3");
        codeMap.put("WPC1255", "iso8859-8");
        codeMap.put("WPC1256", "iso8859-6");
        codeMap.put("WPC1257", "iso8859-1");
        codeMap.put("WPC1258", "bg2312");
        codeMap.put("MIK(Cyrillic/Bulgarian)", "iso8859-15");
        codeMap.put("CP755(East Europe,Latvian 2)", "iso8859-5");
        codeMap.put("Iran", "iso8859-6");
        codeMap.put("Iran II", "iso8859-6");
        codeMap.put("Latvian", "iso8859-4");
        codeMap.put("ISO-8859-1(West Europe)", "iso8859-1");
        codeMap.put("ISO-8859-3(Latin 3)", "iso8859-3");
        codeMap.put("ISO-8859-4(Baltic)", "iso8859-4");
        codeMap.put("ISO-8859-5(Cyrillic)", "iso8859-5");
        codeMap.put("ISO-8859-6(Arabic)", "iso8859-6");
        codeMap.put("ISO-8859-8(Hebrew)", "iso8859-8");
        codeMap.put("ISO-8859-9(Turkish)", "iso8859-9");
        codeMap.put("PC856", "iso8859-8");
        codeMap.put("ABICOIM", "iso8859-15");
        return (String)codeMap.get(codePage);
    }
}

