/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.util.ArrayList;
import java.util.List;

public class PrinterDataCore {
    public int BitmapWidth = 0;
    public int PrintDataHeight = 0;
    public byte HalftoneMode = 1;
    public byte ScaleMode = 0;
    public byte CompressMode = 0;
    private int LBlank = 0;
    private int RBlank = 0;

    public byte[] PrintDataFormat(Bitmap bmp) {
        try {
            byte[] bPrintData = this.HalftoneMode > 0 ? this.GetImageDataRasterMono(bmp) : this.CreatePrintBitmpaData(bmp);
            if (this.CompressMode == 0) {
                return this.AddPrintCode(bPrintData);
            }
            return bPrintData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] CompressPrintData(byte[] pData) {
        try {
            byte[] bOneLine = new byte[this.BitmapWidth];
            ArrayList<byte[]> AllDatas = new ArrayList<byte[]>();
            ArrayList<Object> LineDatas = new ArrayList<byte[]>();
            ArrayList<Object> BlankDatas = new ArrayList<byte[]>();
            int rowL = 0;
            int rowR = 0;
            int i = 0;
            while (i < this.PrintDataHeight) {
                boolean bBlankLine = true;
                byte OnePix = 0;
                rowL = 0;
                rowR = 0;
                int iRowColIdx = i * this.BitmapWidth;
                bOneLine = new byte[this.BitmapWidth];
                int j = 0;
                while (j < this.BitmapWidth) {
                    OnePix = pData[iRowColIdx + j];
                    if (OnePix != 0) {
                        if (j == 0) {
                            rowL = 0;
                        } else if (rowL > rowR) {
                            rowL = rowR;
                        }
                        rowR = j;
                        bBlankLine = false;
                    }
                    bOneLine[j] = OnePix;
                    ++j;
                }
                if (!bBlankLine) {
                    this.LBlank = this.LBlank == 0 ? rowL : (this.LBlank < rowL ? this.LBlank : rowL);
                    this.RBlank = this.RBlank < rowR ? rowR : this.RBlank;
                    int BlankDatasSize = BlankDatas.size();
                    if (BlankDatasSize > 0) {
                        if (BlankDatasSize > 24) {
                            if (LineDatas.size() > 0) {
                                AllDatas.add(this.TrimBitmapBlank(LineDatas));
                            }
                            AllDatas.add(this.CreateFeedLineCMD(BlankDatas));
                            LineDatas = new ArrayList();
                        } else {
                            LineDatas.addAll(BlankDatas);
                        }
                        BlankDatas = new ArrayList();
                    }
                    LineDatas.add(bOneLine);
                } else {
                    BlankDatas.add(bOneLine);
                }
                ++i;
            }
            int BlankDatasSize = BlankDatas.size();
            if (BlankDatasSize > 0) {
                if (BlankDatasSize > 24) {
                    if (LineDatas.size() > 0) {
                        AllDatas.add(this.TrimBitmapBlank(LineDatas));
                    }
                    AllDatas.add(this.CreateFeedLineCMD(BlankDatas));
                } else {
                    LineDatas.addAll(BlankDatas);
                    AllDatas.add(this.TrimBitmapBlank(LineDatas));
                }
            } else {
                AllDatas.add(this.TrimBitmapBlank(LineDatas));
            }
            byte[] bStream = this.sysCopy(AllDatas);
            return bStream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] CreateFeedLineCMD(List<byte[]> BlankDatas) {
        try {
            ArrayList<byte[]> BL = new ArrayList<byte[]>();
            int iLine = 0;
            int iLineCnt = BlankDatas.size();
            while (iLine < iLineCnt) {
                byte[] byArray = new byte[3];
                byArray[0] = 27;
                byArray[1] = 74;
                byte[] OneFeedCMD = byArray;
                OneFeedCMD[2] = iLineCnt - iLine > 240 ? -16 : (byte)(iLineCnt - iLine);
                BL.add(OneFeedCMD);
                iLine += 240;
            }
            byte[] bBL = this.sysCopy(BL);
            return bBL;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] TrimBitmapBlank(List<byte[]> LineDatas) {
        try {
            int iDataWid = this.RBlank - this.LBlank + 1;
            int iLine = 0;
            int iLineCnt = LineDatas.size();
            int iMaxHeight = 2300;
            int iPKIndex = 0;
            int iPackage = iLineCnt % iMaxHeight > 0 ? iLineCnt / iMaxHeight + 1 : iLineCnt / iMaxHeight;
            byte[] RtnData = new byte[iDataWid * iLineCnt + 8 * iPackage];
            while (iLine < iLineCnt) {
                int iCurPackageLine = iLine + iMaxHeight < iLineCnt ? iMaxHeight : iLineCnt - iLine;
                int iCurPackageBegin = (8 + iMaxHeight) * iPKIndex;
                RtnData[iCurPackageBegin] = 29;
                RtnData[iCurPackageBegin + 1] = 118;
                RtnData[iCurPackageBegin + 2] = 48;
                RtnData[iCurPackageBegin + 3] = this.ScaleMode;
                RtnData[iCurPackageBegin + 4] = (byte)(iDataWid % 256);
                RtnData[iCurPackageBegin + 5] = (byte)(iDataWid / 256);
                RtnData[iCurPackageBegin + 6] = (byte)(iCurPackageLine % 256);
                RtnData[iCurPackageBegin + 7] = (byte)(iCurPackageLine / 256);
                int l = iLine;
                while (l < iLineCnt) {
                    System.arraycopy(LineDatas.get(l), this.LBlank, RtnData, (8 + iMaxHeight) * iPKIndex + l * iDataWid + 8, iDataWid);
                    ++l;
                }
                iLine += iMaxHeight;
                ++iPKIndex;
            }
            this.LBlank = 0;
            this.RBlank = 0;
            return RtnData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] AddPrintCode(byte[] bDatas) {
        try {
            byte[] LData = new byte[bDatas.length + 8];
            LData[0] = 29;
            LData[1] = 118;
            LData[2] = 48;
            LData[3] = 0;
            LData[4] = (byte)(this.BitmapWidth % 256);
            LData[5] = (byte)(this.BitmapWidth / 256);
            LData[6] = (byte)(this.PrintDataHeight % 256);
            LData[7] = (byte)(this.PrintDataHeight / 256);
            System.out.println(this.BitmapWidth + " " + this.PrintDataHeight);
            int i = 0;
            while (i < bDatas.length) {
                LData[i + 8] = bDatas[i];
                ++i;
            }
            return LData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] GetImageDataRasterMono(Bitmap pimage) {
        int width = pimage.getWidth();
        int height = pimage.getHeight();
        int w = width;
        int h = height;
        int i = 0;
        int j = 0;
        int d = 0;
        int b = 0;
        int q = 0;
        int q2 = 0;
        int nSize = 0;
        int nPrintDataSize = 0;
        int wBytes = width + 7 >> 3;
        int[] grayImageData = null;
        Object bmpImageData = null;
        try {
            this.PrintDataHeight = height;
            this.BitmapWidth = wBytes;
            nSize = w * h;
            nPrintDataSize = wBytes * h;
            grayImageData = new int[nSize];
            pimage.getPixels(grayImageData, 0, w, 0, 0, w, h);
            j = 0;
            while (j < nSize) {
                int pixel = grayImageData[j];
                grayImageData[q++] = 0xFF & (byte)((double)Color.red((int)pixel) * 0.29891 + (double)Color.green((int)pixel) * 0.58661 + (double)Color.blue((int)pixel) * 0.11448);
                ++j;
            }
            q = 0;
            j = 0;
            while (j < h) {
                q = j * w;
                i = 0;
                while (i < w) {
                    float quant_error;
                    if (grayImageData[q] > 128) {
                        quant_error = grayImageData[q] - 255;
                        grayImageData[q] = 255;
                    } else {
                        quant_error = grayImageData[q] - 0;
                        grayImageData[q] = 0;
                    }
                    if (i < w - 1) {
                        int n = q + 1;
                        grayImageData[n] = grayImageData[n] + (int)(0.4375 * (double)quant_error);
                    }
                    if (j < h - 1) {
                        if (i > 1) {
                            int n = q + w - 1;
                            grayImageData[n] = grayImageData[n] + (int)(0.1875 * (double)quant_error);
                        }
                        int n = q + w;
                        grayImageData[n] = grayImageData[n] + (int)(0.3125 * (double)quant_error);
                        if (i < w - 1) {
                            int n2 = q + w + 1;
                            grayImageData[n2] = grayImageData[n2] + (int)(0.0625 * (double)quant_error);
                        }
                    }
                    ++q;
                    ++i;
                }
                ++j;
            }
            q = 0;
            q2 = 0;
            byte[] r = new byte[nPrintDataSize];
            j = 0;
            while (j < h) {
                if (j == h - 1) {
                    int z = 0;
                    ++z;
                }
                q = j * w;
                q2 = j * wBytes;
                d = 0;
                i = 0;
                while (i < w) {
                    b = i % 8;
                    if (grayImageData[q++] <= 128) {
                        d |= 128 >> b;
                    }
                    if (b != 7 && ++i != w) continue;
                    r[q2++] = (byte)d;
                    d = 0;
                }
                ++j;
            }
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] CreatePrintBitmpaData(Bitmap bmp) {
        int r = 0;
        int g = 0;
        int b = 0;
        int avg = 0;
        int startLine = 0;
        int nDataIndex = 0;
        int nBitIndex = 0;
        try {
            int nHeight;
            int nWidth = bmp.getWidth();
            this.PrintDataHeight = nHeight = bmp.getHeight();
            int nRealWidth = nWidth % 8 == 0 ? nWidth : (nWidth / 8 + 1) * 8;
            this.BitmapWidth = nRealWidth / 8;
            int nSize = nHeight * this.BitmapWidth;
            byte[] bPrintData = new byte[nSize];
            int i = 0;
            while (i < nSize) {
                bPrintData[i] = 0;
                ++i;
            }
            while (startLine < nHeight) {
                int[] arrPixColor = new int[nWidth];
                bmp.getPixels(arrPixColor, 0, nWidth, 0, startLine, nWidth, 1);
                nBitIndex = 0;
                int w = 0;
                while (w < nWidth) {
                    int nPixColor = arrPixColor[w];
                    if (++nBitIndex > 8) {
                        nBitIndex = 1;
                        ++nDataIndex;
                    }
                    if (nPixColor != -1) {
                        int nTempValue = 1;
                        nTempValue <<= 8 - nBitIndex;
                        r = Color.red((int)nPixColor);
                        avg = (r + (g = Color.green((int)nPixColor)) + (b = Color.blue((int)nPixColor))) / 3;
                        if (avg < 128) {
                            bPrintData[nDataIndex] = (byte)(bPrintData[nDataIndex] | nTempValue);
                        }
                    }
                    ++w;
                }
                nDataIndex = this.BitmapWidth * (startLine + 1);
                ++startLine;
            }
            return bPrintData;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] sysCopy(List<byte[]> srcArrays) {
        int len = 0;
        for (byte[] srcArray : srcArrays) {
            len += srcArray.length;
        }
        byte[] destArray = new byte[len];
        int destLen = 0;
        for (byte[] srcArray : srcArrays) {
            System.arraycopy(srcArray, 0, destArray, destLen, srcArray.length);
            destLen += srcArray.length;
        }
        return destArray;
    }
}

