/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import HPRTAndroidSDK.BTOperator;
import HPRTAndroidSDK.IPort;
import HPRTAndroidSDK.PrinterDataCore;
import HPRTAndroidSDK.PublicFunction;
import HPRTAndroidSDK.USBOperator;
import HPRTAndroidSDK.WiFiOperator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.hardware.usb.UsbDevice;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class HPRTPrinterHelper
implements Serializable {
    private static Context PreContext = null;
    private static String PrinterName = null;
    private static IPort Printer = null;
    private static boolean isPortOpen;
    public int BitmapWidth = 0;
    public int PrintDataHeight = 0;
    private static PublicFunction PF;
    public static String LanguageEncode;
    public static int BetweenWriteAndReadDelay;
    private static int PrinterClass;
    private static String sPortType;
    private static boolean Is_BLE_Type;
    static final int PROPERTY_LENGTH = 500;
    private static int printer_class;
    public static String TEXT;
    public static String TEXT_Anti_White;
    public static String TEXT90;
    public static String TEXT180;
    public static String TEXT270;
    public static String CONCAT;
    public static String VCONCAT;
    public static String CENTER;
    public static String LEFT;
    public static String RIGHT;
    public static String BARCODE;
    public static String VBARCODE;
    public static String UPCA;
    public static String UPCA2;
    public static String UPCA5;
    public static String UPCE;
    public static String UPCE2;
    public static String UPCE5;
    public static String EAN13;
    public static String EAN132;
    public static String EAN135;
    public static String EAN8;
    public static String EAN82;
    public static String EAN85;
    public static String code39;
    public static String code39C;
    public static String F39;
    public static String F39C;
    public static String code93;
    public static String I2OF5;
    public static String I2OF5C;
    public static String I2OF5G;
    public static String code128;
    public static String UCCEAN128;
    public static String CODABAR;
    public static String CODABAR16;
    public static String MSI;
    public static String MSI10;
    public static String MSI1010;
    public static String MSI1110;
    public static String POSTNET;
    public static String FIM;
    public static String EXPANDED_GRAPHICS;
    public static String VEXPANDED_GRAPHICS;
    public static String COMPRESSED_GRAPHICS;
    public static String VCOMPRESSED_GRAPHICS;
    private static final String CODE = "utf-8";
    public static final int HPRT_MODEL_TP801 = 4097;
    public static final int HPRT_MODEL_TP805 = 4098;
    public static final int HPRT_MODEL_TP806 = 4099;
    public static final int HPRT_MODEL_DT210 = 4102;
    public static final int HPRT_MODEL_PPT2_A = 4113;
    public static final int HPRT_MODEL_PPT2_UR = 4114;
    public static final int HPRT_MODEL_PPTD3 = 4129;
    public static final int HPRT_MODEL_MPT2 = 4353;
    public static final int HPRT_MODEL_MPT3 = 4354;
    public static final int HPRT_MODEL_MLP2 = 4355;
    public static final int HPRT_MODEL_MPS3 = 4356;
    public static final int HPRT_MODEL_MPD2 = 4401;
    public static final int HPRT_MODEL_MPT_E2 = 4433;
    public static final int HPRT_MODEL_MPT8 = 4497;
    public static final int HPRT_MODEL_PT541 = 5441;
    public static final int HPRT_MODEL_PT562 = 5474;
    public static final int HPRT_MODEL_PT721 = 5921;
    public static final int HPRT_MODEL_LP106B = 37121;
    public static final int HPRT_MODEL_LPQ58 = 38401;
    public static final int HPRT_MODEL_LPQ80 = 38402;
    public static final int HPRT_MODEL_UNKNOWN = -1;
    public static final int HPRT_MODEL_INVALID = -1;
    public static final int HPRT_MODEL_MAX = 31;
    public static final byte HPRT_FULL_CUT = 0;
    public static final byte HPRT_FULL_CUT_FEED = 65;
    public static final byte HPRT_PARTIAL_CUT = 1;
    public static final byte HPRT_PARTIAL_CUT_FEED = 66;
    public static final int HPRT_MODEL_PROPERTY_KEY_ID = 1;
    public static final int HPRT_MODEL_PROPERTY_KEY_NAME = 2;
    public static final int HPRT_MODEL_PROPERTY_PRINTER_CLASS = 3;
    public static final int HPRT_MODEL_PROPERTY_CONNECT_TYPE = 4;
    public static final int HPRT_MODEL_PROPERTY_KEY_MANUFACTURE = 33;
    public static final int HPRT_MODEL_PROPERTY_KEY_IDENTITY = 34;
    public static final int HPRT_MODEL_PROPERTY_KEY_DESCRIPTION = 35;
    public static final int HPRT_MODEL_PROPERTY_KEY_WIDTH = 36;
    public static final int HPRT_MODEL_PROPERTY_KEY_VID = 37;
    public static final int HPRT_MODEL_PROPERTY_KEY_PID = 38;
    public static final int HPRT_MODEL_PROPERTY_KEY_FONTS = 49;
    public static final int HPRT_MODEL_PROPERTY_KEY_BOLD = 50;
    public static final int HPRT_MODEL_PROPERTY_KEY_UNDERLINE = 51;
    public static final int HPRT_MODEL_PROPERTY_KEY_MAX_FONT_SCALE_SIZE = 52;
    public static final int HPRT_MODEL_PROPERTY_KEY_DPI = 65;
    public static final int HPRT_MODEL_PROPERTY_KEY_MOTION_V = 66;
    public static final int HPRT_MODEL_PROPERTY_KEY_MOTION_H = 67;
    public static final int HPRT_MODEL_PROPERTY_KEY_COMPRESS_MODE = 113;
    public static final int HPRT_MODEL_PROPERTY_KEY_PAGEMODE = 129;
    public static final int HPRT_MODEL_PROPERTY_KEY_PAGEMODE_AREA = 130;
    public static final int HPRT_MODEL_PROPERTY_KEY_PRINT_RECEIPT = 130;
    public static final int HPRT_MODEL_PROPERTY_KEY_DRAWER = 145;
    public static final int HPRT_MODEL_PROPERTY_KEY_BEEP = 146;
    public static final int HPRT_MODEL_PROPERTY_KEY_CUT = 147;
    public static final int HPRT_MODEL_PROPERTY_KEY_CUT_SPACING = 148;
    public static final int HPRT_MODEL_PROPERTY_KEY_TEAR_SPACING = 149;
    public static final int HPRT_MODEL_PROPERTY_KEY_BARCODE = 150;
    public static final int HPRT_MODEL_PROPERTY_KEY_BITMAPMODE = 151;
    public static final int HPRT_MODEL_PROPERTY_KEY_GET_REMAINING_POWER = 152;
    public static final int HPRT_MODEL_PROPERTY_KEY_STATUS_MODEL = 153;
    public static final int HPRT_MODEL_PROPERTY_TYPE_BOOL = 1;
    public static final int HPRT_MODEL_PROPERTY_TYPE_STRING = 2;
    public static final int HPRT_MODEL_PROPERTY_TYPE_INT = 3;
    public static final int HPRT_MODEL_PROPERTY_TYPE_BYTE = 4;
    public static final int ACTIVITY_IMAGE_FILE = 1;
    public static final int ACTIVITY_PRNFILE = 2;
    public static final int ACTIVITY_CONNECT_BT = 3;
    public static final int ACTIVITY_CONNECT_WIFI = 4;
    public static final int BC_UPCA = 65;
    public static final int BC_UPCE = 66;
    public static final int BC_EAN13 = 67;
    public static final int BC_EAN8 = 68;
    public static final int BC_CODE39 = 69;
    public static final int BC_ITF = 70;
    public static final int BC_CODEBAR = 71;
    public static final int BC_CODE93 = 72;
    public static final int BC_CODE128 = 73;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_PRINTER = 1;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_ONOFFLINE = 2;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_ERROR = 3;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_PAPER = 4;

    static {
        PF = new PublicFunction();
        LanguageEncode = "GBK";
        BetweenWriteAndReadDelay = 1500;
        sPortType = "";
        Is_BLE_Type = false;
        printer_class = 2;
        TEXT = "T";
        TEXT_Anti_White = "TR";
        TEXT90 = "T90";
        TEXT180 = "T180";
        TEXT270 = "T270";
        CONCAT = "CONCAT";
        VCONCAT = "VCONCAT";
        CENTER = "CENTER";
        LEFT = "LEFT";
        RIGHT = "RIGHT";
        BARCODE = "BARCODE";
        VBARCODE = "VBARCODE";
        UPCA = "UPCA";
        UPCA2 = "UPCA2";
        UPCA5 = "UPCA5";
        UPCE = "UPCE";
        UPCE2 = "UPCE2";
        UPCE5 = "UPCE5";
        EAN13 = "EAN13";
        EAN132 = "EAN132";
        EAN135 = "EAN135";
        EAN8 = "EAN8";
        EAN82 = "EAN82";
        EAN85 = "EAN85";
        code39 = "39";
        code39C = "39C";
        F39 = "F39";
        F39C = "F39C";
        code93 = "93";
        I2OF5 = "I2OF5";
        I2OF5C = "I2OF5C";
        I2OF5G = "I2OF5G";
        code128 = "128";
        UCCEAN128 = "UCCEAN128";
        CODABAR = "CODABAR";
        CODABAR16 = "CODABAR16";
        MSI = "MSI";
        MSI10 = "MSI10";
        MSI1010 = "MSI1010";
        MSI1110 = "MSI1110";
        POSTNET = "POSTNET";
        FIM = "FIM";
        EXPANDED_GRAPHICS = "EG";
        VEXPANDED_GRAPHICS = "VEG";
        COMPRESSED_GRAPHICS = "CG";
        VCOMPRESSED_GRAPHICS = "VCG";
    }

    public void IsBLEType(boolean isBLEType) {
        Is_BLE_Type = isBLEType;
    }

    public int CharacterSet() {
        return 0;
    }

    public static String PortType() {
        return sPortType;
    }

    public static boolean IsOpened() {
        return isPortOpen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int PortOpen(String portSetting) throws Exception {
        if (portSetting.trim().length() <= 4) return -1;
        String[] strPort = portSetting.split(",");
        if (strPort[0].equals("Bluetooth")) {
            if (strPort.length != 2) {
                return -1;
            }
            Printer = new BTOperator(PreContext, PrinterName);
            Printer.IsBLEType(Is_BLE_Type);
            isPortOpen = Printer.OpenPort(strPort[1]);
            sPortType = "Bluetooth";
            if (isPortOpen) return 0;
            return -1;
        }
        if (!strPort[0].equals("WiFi")) return -1;
        if (strPort.length != 3) {
            return -1;
        }
        Printer = new WiFiOperator(PreContext, PrinterName);
        isPortOpen = Printer.OpenPort(strPort[1], strPort[2]);
        sPortType = "WiFi";
        if (isPortOpen) return 0;
        return -1;
    }

    public static int PortOpen(UsbDevice usbdevice) throws Exception {
        if (usbdevice == null) {
            return -1;
        }
        Printer = new USBOperator(PreContext, PrinterName);
        isPortOpen = Printer.OpenPort(usbdevice);
        sPortType = "USB";
        return isPortOpen ? 0 : -1;
    }

    public static boolean PortClose() throws Exception {
        boolean blnOK = true;
        if (Printer != null) {
            blnOK = Printer.ClosePort();
        }
        isPortOpen = !blnOK;
        return blnOK;
    }

    public static int PrintData(byte[] data) throws Exception {
        int iRtn = Printer.WriteData(data, data.length);
        return iRtn;
    }

    public static boolean FillBitmapToBufferOfPageMode(Bitmap bmp, byte halftoneType, byte scaleMode) throws Exception {
        HPRTPrinterHelper.CreateBitmapPrintDatas(bmp, halftoneType, scaleMode);
        return true;
    }

    public static byte[] PrintBitmap(Bitmap bmp, byte halftoneType, byte scaleMode) throws Exception {
        byte[] createBitmapPrintDatas = HPRTPrinterHelper.CreateBitmapPrintDatas(bmp, halftoneType, scaleMode);
        return createBitmapPrintDatas;
    }

    public static byte[] PrintImage(String filePath, int x, int y, byte halftoneType, byte scaleMode) throws Exception {
        Bitmap bmp = BitmapFactory.decodeFile((String)filePath);
        Bitmap createBitmap = Bitmap.createBitmap((int)(bmp.getWidth() + x), (int)(bmp.getHeight() + y), (Bitmap.Config)bmp.getConfig());
        createBitmap = HPRTPrinterHelper.replaceBitmapColor(createBitmap, 0, -1);
        Canvas canvas = new Canvas(createBitmap);
        Paint paint = new Paint();
        RectF dst = new RectF((float)x, (float)y, (float)(bmp.getWidth() + x), (float)(bmp.getHeight() + y));
        canvas.drawBitmap(bmp, null, dst, paint);
        canvas.save(31);
        canvas.restore();
        return HPRTPrinterHelper.PrintBitmap(createBitmap, halftoneType, scaleMode);
    }

    public static Bitmap replaceBitmapColor(Bitmap oldBitmap, int oldColor, int newColor) {
        Bitmap mBitmap = oldBitmap.copy(Bitmap.Config.ARGB_8888, true);
        int mBitmapWidth = mBitmap.getWidth();
        int mBitmapHeight = mBitmap.getHeight();
        int mArrayColorLengh = mBitmapWidth * mBitmapHeight;
        int[] mArrayColor = new int[mArrayColorLengh];
        boolean count = false;
        int i = 0;
        while (i < mBitmapHeight) {
            int j = 0;
            while (j < mBitmapWidth) {
                int color = mBitmap.getPixel(j, i);
                if (color == oldColor) {
                    mBitmap.setPixel(j, i, newColor);
                }
                ++j;
            }
            ++i;
        }
        return mBitmap;
    }

    public static byte[] Printtextbitmap(int x, String str, int textsize, int textperline, int space) throws Exception {
        String[] context = new String[1024];
        int i = 0;
        if (str.length() > textperline) {
            int k = 0;
            while (k + textperline <= str.length()) {
                context[i++] = str.substring(k, k + textperline);
                k += textperline;
            }
            context[i++] = str.substring(k, str.length());
        } else {
            i = 1;
            context[0] = str;
        }
        int bitmapwidth = str.length() > textperline ? textperline : str.length();
        Bitmap bitmap = Bitmap.createBitmap((int)(bitmapwidth * textsize + x), (int)((textsize + textsize / 10) * i + space), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setTextSize((float)textsize);
        int j = 0;
        while (j < i) {
            canvas.drawText(context[j], (float)x, (float)(textsize * (j + 1)), paint);
            ++j;
        }
        canvas.save(31);
        canvas.restore();
        bitmap = HPRTPrinterHelper.replaceBitmapColor(bitmap, 0, -1);
        return HPRTPrinterHelper.PrintBitmap(bitmap, (byte)0, (byte)0);
    }

    public static byte[] createQRImage(String url, int Align, int QRsize) throws Exception {
        int QRx;
        block15: {
            QRx = 0;
            if (url != null && !"".equals(url) && url.length() >= 1) break block15;
            return null;
        }
        try {
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, CODE);
            BitMatrix matrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, QRsize, QRsize, hints);
            int width = matrix.getWidth();
            int height = matrix.getHeight();
            int[] pixels = new int[width * height];
            boolean isFirstBlackPoint = false;
            int startX = 0;
            int startY = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if (matrix.get(x, y)) {
                        if (!isFirstBlackPoint) {
                            isFirstBlackPoint = true;
                            startX = x;
                            startY = y;
                            Log.d((String)"createQRCode", (String)("x y = " + x + " " + y));
                        }
                        pixels[y * width + x] = -16777216;
                    }
                    ++x;
                }
                ++y;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            if (startX > 0) {
                int x1 = startX - 0;
                int y1 = startY - 0;
                int w1 = width - x1 * 2;
                int h1 = height - y1 * 2;
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x1, (int)y1, (int)w1, (int)h1);
            }
            if (bitmap.getWidth() > 384) {
                QRx = 0;
            } else {
                switch (Align) {
                    case 0: {
                        QRx = 0;
                        break;
                    }
                    case 1: {
                        QRx = (384 - bitmap.getWidth()) / 2;
                        break;
                    }
                    case 2: {
                        QRx = 384 - bitmap.getWidth();
                        break;
                    }
                }
            }
            Bitmap createBitmap = Bitmap.createBitmap((int)(bitmap.getWidth() + QRx), (int)bitmap.getHeight(), (Bitmap.Config)bitmap.getConfig());
            createBitmap = HPRTPrinterHelper.replaceBitmapColor(createBitmap, 0, -1);
            Canvas canvas = new Canvas(createBitmap);
            Paint paint = new Paint();
            RectF dst = new RectF((float)QRx, 0.0f, (float)(bitmap.getWidth() + QRx), (float)bitmap.getHeight());
            canvas.drawBitmap(bitmap, null, dst, paint);
            canvas.save(31);
            canvas.restore();
            return HPRTPrinterHelper.PrintBitmap(createBitmap, (byte)0, (byte)0);
        }
        catch (WriterException e) {
            return null;
        }
    }

    public static byte[] creatBarcode(Context context, String contents, int Align, int desiredWidth, int desiredHeight, boolean displayCode) throws Exception {
        Bitmap ruseltBitmap = null;
        int barcode_x = 0;
        boolean marginW = false;
        if (displayCode) {
            Bitmap barcodeBitmap = HPRTPrinterHelper.getBarcode(contents, desiredWidth, desiredHeight);
            Bitmap codeBitmap = HPRTPrinterHelper.creatCodeBitmap(contents, barcodeBitmap.getWidth(), desiredHeight, context);
            ruseltBitmap = HPRTPrinterHelper.mixtureBitmap(barcodeBitmap, codeBitmap, new PointF(0.0f, (float)desiredHeight));
        } else {
            ruseltBitmap = HPRTPrinterHelper.getBarcode(contents, desiredWidth, desiredHeight);
        }
        if (ruseltBitmap.getWidth() > 384) {
            barcode_x = 0;
        } else {
            switch (Align) {
                case 0: {
                    barcode_x = 0;
                    break;
                }
                case 1: {
                    barcode_x = (384 - ruseltBitmap.getWidth()) / 2;
                    break;
                }
                case 2: {
                    barcode_x = 384 - ruseltBitmap.getWidth();
                    break;
                }
            }
        }
        Bitmap createBitmap = Bitmap.createBitmap((int)(ruseltBitmap.getWidth() + barcode_x), (int)ruseltBitmap.getHeight(), (Bitmap.Config)ruseltBitmap.getConfig());
        createBitmap = HPRTPrinterHelper.replaceBitmapColor(createBitmap, 0, -1);
        Canvas canvas = new Canvas(createBitmap);
        Paint paint = new Paint();
        RectF dst = new RectF((float)barcode_x, 0.0f, (float)(ruseltBitmap.getWidth() + barcode_x), (float)ruseltBitmap.getHeight());
        canvas.drawBitmap(ruseltBitmap, null, dst, paint);
        canvas.save(31);
        canvas.restore();
        return HPRTPrinterHelper.PrintBitmap(createBitmap, (byte)0, (byte)0);
    }

    public static Bitmap getBarcode(String str, Integer width, Integer height) {
        if (width == null || width < 200) {
            width = 200;
        }
        if (height == null || height < 50) {
            height = 50;
        }
        try {
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, CODE);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(str, BarcodeFormat.CODE_128, width.intValue(), height.intValue(), hints);
            return HPRTPrinterHelper.BitMatrixToBitmap(bitMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap BitMatrixToBitmap(BitMatrix matrix) {
        int WHITE = -1;
        int BLACK = -16777216;
        int startX = 0;
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        int[] pixels = new int[width * height];
        int y = 0;
        while (y < height) {
            int offset = y * width;
            int x = 0;
            while (x < width) {
                if (matrix.get(x, y)) {
                    startX = x;
                }
                pixels[offset + x] = matrix.get(x, y) ? -16777216 : -1;
                ++x;
            }
            ++y;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        if (startX > 0) {
            int x1 = width - startX;
            int w1 = width - x1 * 2;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)x1, (int)0, (int)w1, (int)height);
        }
        return bitmap;
    }

    protected static Bitmap creatCodeBitmap(String contents, int width, int height, Context context) {
        TextView tv = new TextView(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        tv.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        tv.setText((CharSequence)contents);
        tv.setGravity(1);
        tv.setWidth(width);
        tv.setDrawingCacheEnabled(true);
        tv.setTextColor(-16777216);
        tv.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        tv.layout(0, 0, tv.getMeasuredWidth(), tv.getMeasuredHeight());
        tv.buildDrawingCache();
        Bitmap bitmapCode = tv.getDrawingCache();
        return bitmapCode;
    }

    protected static Bitmap mixtureBitmap(Bitmap first, Bitmap second, PointF fromPoint) {
        if (first == null || second == null || fromPoint == null) {
            return null;
        }
        boolean marginW = false;
        Bitmap newBitmap = Bitmap.createBitmap((int)first.getWidth(), (int)(first.getHeight() + second.getHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newBitmap);
        cv.drawBitmap(first, (float)marginW, 0.0f, null);
        cv.drawBitmap(second, fromPoint.x, fromPoint.y, null);
        cv.save(31);
        cv.restore();
        return newBitmap;
    }

    private static byte[] CreateBitmapPrintDatas(Bitmap bmp, byte halftoneType, byte scaleMode) {
        PrinterDataCore PDC = new PrinterDataCore();
        PDC.HalftoneMode = halftoneType;
        PDC.ScaleMode = scaleMode;
        byte[] bData = PDC.PrintDataFormat(bmp);
        return bData;
    }

    public static boolean PrintBinaryFile(String filePath) throws Exception {
        byte[] bData = HPRTPrinterHelper.getByteArrayFromFile(filePath);
        Printer.WriteData(bData);
        return true;
    }

    private static byte[] getByteArrayFromFile(String fileName) {
        File file = null;
        try {
            file = new File(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (!(file.exists() && file.isFile() && file.canRead())) {
            return null;
        }
        byte[] byteArray = null;
        try {
            int count;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((count = fis.read(buffer)) > 0) {
                baos.write(buffer, 0, count);
            }
            byteArray = baos.toByteArray();
            fis.close();
            baos.flush();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArray;
    }

    public static int PrintHLines(int count, int[] inDatas) throws Exception {
        if (count < 0 || count >= 8) {
            return -1;
        }
        int nLength = 3 + count * 4;
        byte[] bPrintData = new byte[nLength];
        bPrintData[0] = 29;
        bPrintData[1] = 39;
        bPrintData[2] = (byte)count;
        int nIndex = 3;
        int i = 0;
        while (i < count * 2) {
            int nTemp = inDatas[i];
            bPrintData[nIndex] = (byte)(nTemp %= 256);
            nTemp = inDatas[i];
            bPrintData[++nIndex] = (byte)(nTemp /= 256);
            ++nIndex;
            ++i;
        }
        return Printer.WriteData(bPrintData, nLength);
    }

    public static int PrintCurveText(int flag, int position, String text) throws Exception {
        byte[] bTextData = text.getBytes(LanguageEncode);
        int nLength = bTextData.length + 5 + 1;
        byte[] bPrintData = new byte[nLength];
        bPrintData[0] = 29;
        bPrintData[1] = 34;
        bPrintData[2] = (byte)flag;
        int nTemp = position % 256;
        bPrintData[3] = (byte)nTemp;
        nTemp = position / 256;
        bPrintData[4] = (byte)nTemp;
        int nIndex = 5;
        int i = 0;
        while (i < bTextData.length) {
            bPrintData[nIndex] = bTextData[i];
            ++nIndex;
            ++i;
        }
        bPrintData[nLength - 1] = 0;
        return Printer.WriteData(bPrintData, nLength);
    }

    public static int BackFeed(String backfeed) throws Exception {
        byte[] bData = new byte[500];
        String data = "";
        data = "BACKFEED " + backfeed + "\r\n";
        bData = data.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Form() throws Exception {
        byte[] bData = new byte[500];
        String data = "";
        data = "FORM\r\n";
        bData = data.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Note(String note) throws Exception {
        byte[] bData = new byte[500];
        String data = "";
        data = "; " + note + "\r\n";
        bData = data.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Abort() throws Exception {
        byte[] bData = new byte[500];
        String data = "";
        data = "END\r\n";
        bData = data.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Text_CPCL(String command, String font, String size, String x, String y, String data) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = String.valueOf(command) + " " + font + " " + size + " " + x + " " + y + " " + data + "\r\n";
        bData = strdata.getBytes("gb2312");
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Concat(String command, String x, String y, String[] data) throws Exception {
        byte[] bData = new byte[500];
        String strdata = String.valueOf(command) + " " + x + " " + y + "\r\n";
        int i = 0;
        while (i < data.length) {
            strdata = String.valueOf(strdata) + data[i] + " ";
            if ((i + 1) % 4 == 0) {
                strdata = String.valueOf(strdata) + "\r\n";
            }
            ++i;
        }
        strdata = String.valueOf(strdata) + "ENDCONCAT\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int ML(String ml) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "ML " + ml + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int ENDML() throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "ENDML\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Count(String ml) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "COUNT " + ml + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int SetMag(String width, String height) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "SETMAG " + width + " " + height + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Align(String align) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = String.valueOf(align) + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Barcode_CPCL(String command, String type, String width, String ratio, String height, String x, String y, boolean undertext, String number, String size, String offset, String data) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = String.valueOf(command) + " " + type + " " + width + " " + ratio + " " + height + " " + x + " " + y + " " + data + "\r\n";
        if (undertext) {
            strdata = "BARCODE-TEXT " + number + " " + size + " " + offset + "\r\n" + strdata + "BARCODE-TEXT OFF\r\n";
        }
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int PrintQR_CPCL(String command, String x, String y, String M, String U, String data) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = String.valueOf(command) + " " + "QR" + " " + x + " " + y + " M " + M + " U " + U + "\r\n" + "MA," + data + "\r\n" + "ENDQR\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int PrintPDF417(String command, String x, String y, String XD, String YD, String C, String S, String data) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = String.valueOf(command) + " " + "PDF-417" + " " + x + " " + y + " XD " + XD + " YD " + YD + " C " + C + " S " + S + "\r\n" + data + "\r\n" + "ENDPDF\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Box_CPCL(String X0, String Y0, String X1, String Y1, String width) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "BOX " + X0 + " " + Y0 + " " + X1 + " " + Y1 + " " + width + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Line_CPCL(String X0, String Y0, String X1, String Y1, String width) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "LINE " + X0 + " " + Y0 + " " + X1 + " " + Y1 + " " + width + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int InverseLine(String X0, String Y0, String X1, String Y1, String width) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "INVERSE-LINE " + X0 + " " + Y0 + " " + X1 + " " + Y1 + " " + width + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int printText(String str) throws Exception {
        int iReturn = 0;
        iReturn = Printer.WriteData((String.valueOf(str) + "\r\n").getBytes("GBK"));
        return iReturn;
    }

    public static int Contrast(String contrast) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "CONTRAST " + contrast + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Speed_CPCL(String speed) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "SPEED " + speed + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int SetSp(String setsp) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "SETSP " + setsp + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Prefeed(String prefeed) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "PREFEED " + prefeed + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Postfeed(String posfeed) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "POSFEED " + posfeed + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Country(String country) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "COUNTRY " + country + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Beep(String beep) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "BEEP " + beep + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Underline(boolean UL) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = UL ? "UNDERLINE ON\r\n" : "UNDERLINE OFF\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Wait(String wait) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "WAIT " + wait + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int PageWidth(String pw) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "PW " + pw + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Setlf(String SF) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "! U1 SETLP " + SF + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    public static int Setlp(String font, String size, String spacing) throws Exception {
        byte[] bData = new byte[500];
        String strdata = "";
        strdata = "! U1 SETLP " + font + " " + size + " " + spacing + "\r\n";
        bData = strdata.getBytes(LanguageEncode);
        int iReturn = Printer.WriteData(bData);
        return iReturn;
    }

    /*
     * Unable to fully structure code
     */
    public static int printSingleInterface(String url, HashMap<String, String> map) throws Exception {
        a = 0;
        if (url == null && map == null) {
            a = 1;
            return 1;
        }
        keySet = map.keySet();
        iterator = keySet.iterator();
        file = new File(url);
        if (file == null) {
            Log.e((String)"TGA", (String)(String.valueOf(url) + "\u8def\u5f84\u9519\u8bef"));
            a = 1;
            return 1;
        }
        fis = new FileInputStream(file);
        if (fis == null) {
            Log.e((String)"TGA", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            a = 1;
            return 1;
        }
        path = new String(HPRTPrinterHelper.InputStreamToByte(fis), "utf-8");
        if (path != null) ** GOTO lbl25
        a = 1;
        return 1;
lbl-1000:
        // 1 sources

        {
            string = iterator.next();
            path = path.replace(string, map.get(string));
lbl25:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl26:
        // 1 sources

        HPRTPrinterHelper.Printer.WriteData((String.valueOf(path) + "\r\n").getBytes("GBK"));
        return a;
    }

    public static int printSingleInterface(InputStream is, HashMap<String, String> pum) throws Exception {
        int a = 0;
        if (is == null || pum == null) {
            a = 1;
            return 1;
        }
        Set<String> keySet = pum.keySet();
        Iterator<String> iterator = keySet.iterator();
        String path = new String(HPRTPrinterHelper.InputStreamToByte(is), CODE);
        while (iterator.hasNext()) {
            String string = iterator.next();
            path = path.replace(string, pum.get(string));
        }
        System.out.println("path:" + path);
        HPRTPrinterHelper.PrintData(path);
        return a;
    }

    private static byte[] InputStreamToByte(InputStream is) throws IOException {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = is.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }

    public static int PrintData(String str) throws Exception {
        int iReturn = Printer.WriteData((String.valueOf(str) + "\r\n").getBytes(LanguageEncode));
        return iReturn;
    }

    public static int SetBold(String bold) throws Exception {
        int iReturn = Printer.WriteData(("SETBOLD " + bold + "\r\n").getBytes(LanguageEncode));
        return iReturn;
    }

    public static int getstatus() throws Exception {
        int readData = -1;
        byte[] by = new byte[]{27, 104};
        int iReturn = Printer.WriteData(by);
        byte[] ry = new byte[1];
        if (iReturn > 0 && (readData = Printer.ReadData(ry)) > 0) {
            readData = ry[0] & 0xFF;
        }
        return readData;
    }
}

