/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import HPRTAndroidSDK.IPort;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.UUID;

public class BTOperator
implements IPort {
    private BluetoothAdapter mBluetoothAdapter;
    private InputStream mmInStream;
    private OutputStream mmOutStream;
    private BluetoothSocket mmSocket;
    private BluetoothDevice mmDevice;
    private String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    private static final UUID MY_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static String bluetoothAddress = "";
    private static String PrinterName = "";
    private static String InPrinterName = "";
    private Context PreContext = null;
    private boolean blnOpenPort = false;
    private int IsReConnect = 0;
    private boolean Is_BLE_Type = false;

    public BTOperator(Context context) {
        this.PreContext = context;
        InPrinterName = "HPRT";
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public BTOperator(Context context, String strPrinterName) {
        this.PreContext = context;
        PrinterName = strPrinterName;
        InPrinterName = strPrinterName;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    @Override
    public void IsBLEType(boolean isBLEType) {
        this.Is_BLE_Type = isBLEType;
    }

    @Override
    public void InitPort() {
    }

    @Override
    public void SetReadTimeout(int readTimeout) {
    }

    @Override
    public void SetWriteTimeout(int writeTimeout) {
    }

    @Override
    public boolean OpenPort(UsbDevice usbdevice) {
        return false;
    }

    @Override
    public boolean OpenPort(String PortParam, String PortNumber) {
        return false;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public boolean OpenPort(String PortParam) {
        boolean isOldVersion = false;
        this.mBluetoothAdapter.cancelDiscovery();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        bluetoothAddress = PortParam;
        if (bluetoothAddress == null) {
            return false;
        }
        if (!bluetoothAddress.contains(":")) {
            return false;
        }
        if (bluetoothAddress.length() != 17) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 15) {
            isOldVersion = true;
        }
        try {
            this.mmDevice = this.mBluetoothAdapter.getRemoteDevice(bluetoothAddress);
            this.mmSocket = isOldVersion ? this.mmDevice.createRfcommSocketToServiceRecord(MY_UUID) : this.mmDevice.createInsecureRfcommSocketToServiceRecord(MY_UUID);
            this.mBluetoothAdapter.cancelDiscovery();
            Thread.sleep(500L);
            if (this.mBluetoothAdapter.isDiscovering()) {
                int iCnt = 0;
                while (iCnt < 5) {
                    Thread.sleep(500L);
                    ++iCnt;
                    if (this.mBluetoothAdapter.cancelDiscovery()) break;
                }
            }
            this.mmSocket.connect();
        }
        catch (Exception e) {
            try {
                Method m = this.mmDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this.mmSocket = (BluetoothSocket)m.invoke((Object)this.mmDevice, 1);
                if (this.mBluetoothAdapter.isDiscovering()) {
                    int iCnt = 0;
                    while (iCnt < 5) {
                        Thread.sleep(500L);
                        ++iCnt;
                        if (this.mBluetoothAdapter.cancelDiscovery()) break;
                    }
                }
                this.mmSocket.connect();
            }
            catch (Exception e1) {
                Log.d((String)"PRTLIB", (String)("BTO_ConnectDevice --> create " + e1.getMessage()));
                return false;
            }
        }
        try {
            PrinterName = this.mmDevice.getName();
            this.blnOpenPort = this.GetIOInterface();
            return this.blnOpenPort;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean ClosePort() {
        boolean bRet = true;
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            if (this.mmInStream != null) {
                this.mmInStream.close();
                this.mmInStream = null;
            }
            if (this.mmOutStream != null) {
                this.mmOutStream.close();
                this.mmOutStream = null;
            }
            if (this.mmSocket != null) {
                this.mmSocket.close();
                this.mmSocket = null;
            }
        }
        catch (IOException e) {
            System.out.println("BTO_ConnectDevice close " + e.getMessage());
            bRet = false;
        }
        return bRet;
    }

    @Override
    public int WriteData(byte[] Data) {
        return this.WriteData(Data, 0, Data.length);
    }

    @Override
    public int WriteData(byte[] Data, int intDataLength) {
        return this.WriteData(Data, 0, intDataLength);
    }

    @Override
    public int WriteData(byte[] Data, int intOffset, int intDataLength) {
        block9: {
            if (this.mmOutStream != null) break block9;
            return -1;
        }
        try {
            if (this.IsReConnect < 2) {
                byte[] tmp = new byte[intDataLength];
                int i = 0;
                while (i < intDataLength) {
                    tmp[i] = Data[intOffset + i];
                    ++i;
                }
                String str = "";
                int i2 = 0;
                while (i2 < tmp.length) {
                    str = String.valueOf(str) + tmp[i2] + " ";
                    ++i2;
                }
                this.mmOutStream.write(tmp, 0, intDataLength);
                this.mmOutStream.flush();
                this.IsReConnect = 0;
                return intDataLength;
            }
            return -1;
        }
        catch (IOException e) {
            if (this.blnOpenPort) {
                if (this.IsReConnect == 1) {
                    this.IsReConnect = 0;
                    return -1;
                }
                if (this.OpenPort(bluetoothAddress)) {
                    ++this.IsReConnect;
                    return this.WriteData(Data, intOffset, intDataLength);
                }
            }
            this.IsReConnect = 0;
            Log.d((String)"PRTLIB", (String)("WriteData --> error " + e.getMessage()));
            return -1;
        }
    }

    @Override
    public int ReadData(byte[] Data, int intOffset, int intLength) {
        int intReadLen;
        block8: {
            block7: {
                intReadLen = 0;
                try {
                    if (this.mmInStream != null) break block7;
                    return -1;
                }
                catch (IOException e) {
                    if (this.blnOpenPort) {
                        if (this.IsReConnect == 1) {
                            this.IsReConnect = 0;
                            return -1;
                        }
                        if (this.OpenPort(bluetoothAddress)) {
                            ++this.IsReConnect;
                            return this.ReadData(Data, intOffset, intLength);
                        }
                    }
                    this.IsReConnect = 0;
                    Log.d((String)"PRTLIB", (String)("ReadData --> error " + e.getMessage()));
                    return -1;
                }
            }
            if (this.IsReConnect < 2) {
                intReadLen = this.mmInStream.read(Data, intOffset, intLength);
                break block8;
            }
            return -1;
        }
        return intReadLen;
    }

    @Override
    public int ReadData(byte[] Data) {
        int intReadLen;
        block8: {
            block7: {
                intReadLen = 0;
                try {
                    if (this.mmInStream != null) break block7;
                    return -1;
                }
                catch (IOException e) {
                    if (this.blnOpenPort) {
                        if (this.IsReConnect == 1) {
                            this.IsReConnect = 0;
                            return -1;
                        }
                        if (this.OpenPort(bluetoothAddress)) {
                            ++this.IsReConnect;
                            return this.ReadData(Data);
                        }
                    }
                    this.IsReConnect = 0;
                    Log.d((String)"PRTLIB", (String)("ReadData --> error " + e.getMessage()));
                    return -1;
                }
            }
            if (this.IsReConnect < 2) {
                intReadLen = this.mmInStream.read(Data);
                break block8;
            }
            return -1;
        }
        return intReadLen;
    }

    @Override
    public boolean IsOpen() {
        return this.blnOpenPort;
    }

    @Override
    public String GetPortType() {
        return "Bluetooth";
    }

    @Override
    public String GetPrinterName() {
        return PrinterName;
    }

    private boolean GetIOInterface() {
        Log.d((String)"PRTLIB", (String)"BTO_GetIOInterface...");
        try {
            this.mmInStream = this.mmSocket.getInputStream();
            this.mmOutStream = this.mmSocket.getOutputStream();
        }
        catch (IOException e) {
            Log.d((String)"PRTLIB", (String)("BTO_GetIOInterface " + e.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public String GetPrinterModel() {
        return PrinterName;
    }
}

