/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.oned.rss.expanded.decoders;

import com.android.zxing.FormatException;
import com.android.zxing.NotFoundException;
import com.android.zxing.common.BitArray;
import com.android.zxing.oned.rss.expanded.decoders.AI01decoder;
import com.android.zxing.oned.rss.expanded.decoders.DecodedInformation;

final class AI01393xDecoder
extends AI01decoder {
    private static final int HEADER_SIZE = 8;
    private static final int LAST_DIGIT_SIZE = 2;
    private static final int FIRST_THREE_DIGITS_SIZE = 10;

    AI01393xDecoder(BitArray information) {
        super(information);
    }

    @Override
    public String parseInformation() throws NotFoundException, FormatException {
        if (this.getInformation().getSize() < 48) {
            throw NotFoundException.getNotFoundInstance();
        }
        StringBuilder buf = new StringBuilder();
        this.encodeCompressedGtin(buf, 8);
        int lastAIdigit = this.getGeneralDecoder().extractNumericValueFromBitArray(48, 2);
        buf.append("(393");
        buf.append(lastAIdigit);
        buf.append(')');
        int firstThreeDigits = this.getGeneralDecoder().extractNumericValueFromBitArray(50, 10);
        if (firstThreeDigits / 100 == 0) {
            buf.append('0');
        }
        if (firstThreeDigits / 10 == 0) {
            buf.append('0');
        }
        buf.append(firstThreeDigits);
        DecodedInformation generalInformation = this.getGeneralDecoder().decodeGeneralPurposeField(60, null);
        buf.append(generalInformation.getNewString());
        return buf.toString();
    }
}

