/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.oned;

import com.android.zxing.BarcodeFormat;
import com.android.zxing.DecodeHintType;
import com.android.zxing.NotFoundException;
import com.android.zxing.ReaderException;
import com.android.zxing.Result;
import com.android.zxing.common.BitArray;
import com.android.zxing.oned.EAN13Reader;
import com.android.zxing.oned.EAN8Reader;
import com.android.zxing.oned.OneDReader;
import com.android.zxing.oned.UPCAReader;
import com.android.zxing.oned.UPCEANReader;
import com.android.zxing.oned.UPCEReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private final UPCEANReader[] readers;

    public MultiFormatUPCEANReader(Map<DecodeHintType, ?> hints) {
        Collection possibleFormats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<UPCEANReader> readers = new ArrayList<UPCEANReader>();
        if (possibleFormats != null) {
            if (possibleFormats.contains((Object)BarcodeFormat.EAN_13)) {
                readers.add(new EAN13Reader());
            } else if (possibleFormats.contains((Object)BarcodeFormat.UPC_A)) {
                readers.add(new UPCAReader());
            }
            if (possibleFormats.contains((Object)BarcodeFormat.EAN_8)) {
                readers.add(new EAN8Reader());
            }
            if (possibleFormats.contains((Object)BarcodeFormat.UPC_E)) {
                readers.add(new UPCEReader());
            }
        }
        if (readers.isEmpty()) {
            readers.add(new EAN13Reader());
            readers.add(new EAN8Reader());
            readers.add(new UPCEReader());
        }
        this.readers = readers.toArray(new UPCEANReader[readers.size()]);
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException {
        int[] startGuardPattern = UPCEANReader.findStartGuardPattern(row);
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n = this.readers.length;
        for (int i = 0; i < n; ++i) {
            boolean canReturnUPCA;
            Result result;
            UPCEANReader reader = uPCEANReaderArray[i];
            try {
                result = reader.decodeRow(rowNumber, row, startGuardPattern, hints);
            }
            catch (ReaderException readerException) {
                continue;
            }
            boolean ean13MayBeUPCA = result.getBarcodeFormat() == BarcodeFormat.EAN_13 && result.getText().charAt(0) == '0';
            Collection possibleFormats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
            boolean bl = canReturnUPCA = possibleFormats == null || possibleFormats.contains((Object)BarcodeFormat.UPC_A);
            if (ean13MayBeUPCA && canReturnUPCA) {
                Result resultUPCA = new Result(result.getText().substring(1), result.getRawBytes(), result.getResultPoints(), BarcodeFormat.UPC_A);
                resultUPCA.putAllMetadata(result.getResultMetadata());
                return resultUPCA;
            }
            return result;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public void reset() {
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n = this.readers.length;
        for (int i = 0; i < n; ++i) {
            uPCEANReaderArray[i].reset();
        }
    }
}

