/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.maxicode.decoder;

import com.android.zxing.ChecksumException;
import com.android.zxing.DecodeHintType;
import com.android.zxing.FormatException;
import com.android.zxing.common.BitMatrix;
import com.android.zxing.common.DecoderResult;
import com.android.zxing.common.reedsolomon.GenericGF;
import com.android.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.android.zxing.common.reedsolomon.ReedSolomonException;
import com.android.zxing.maxicode.decoder.BitMatrixParser;
import com.android.zxing.maxicode.decoder.DecodedBitStreamParser;
import java.util.Map;

public final class Decoder {
    private static final int ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.MAXICODE_FIELD_64);

    public DecoderResult decode(BitMatrix bits) throws ChecksumException, FormatException {
        return this.decode(bits, null);
    }

    public DecoderResult decode(BitMatrix bits, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        byte[] datawords;
        byte[] codewords = new BitMatrixParser(bits).readCodewords();
        this.correctErrors(codewords, 0, 10, 10, 0);
        int mode = codewords[0] & 0xF;
        switch (mode) {
            case 2: 
            case 3: 
            case 4: {
                this.correctErrors(codewords, 20, 84, 40, 1);
                this.correctErrors(codewords, 20, 84, 40, 2);
                datawords = new byte[94];
                break;
            }
            case 5: {
                this.correctErrors(codewords, 20, 68, 56, 1);
                this.correctErrors(codewords, 20, 68, 56, 2);
                datawords = new byte[78];
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        System.arraycopy(codewords, 0, datawords, 0, 10);
        System.arraycopy(codewords, 20, datawords, 10, datawords.length - 10);
        return DecodedBitStreamParser.decode(datawords, mode);
    }

    private void correctErrors(byte[] codewordBytes, int start, int dataCodewords, int ecCodewords, int mode) throws ChecksumException {
        int i;
        int codewords = dataCodewords + ecCodewords;
        int divisor = mode == 0 ? 1 : 2;
        int[] codewordsInts = new int[codewords / divisor];
        for (i = 0; i < codewords; ++i) {
            if (mode != 0 && i % 2 != mode - 1) continue;
            codewordsInts[i / divisor] = codewordBytes[i + start] & 0xFF;
        }
        try {
            this.rsDecoder.decode(codewordsInts, ecCodewords / divisor);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (i = 0; i < dataCodewords; ++i) {
            if (mode != 0 && i % 2 != mode - 1) continue;
            codewordBytes[i + start] = (byte)codewordsInts[i / divisor];
        }
    }
}

