/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.common;

import com.android.zxing.Binarizer;
import com.android.zxing.LuminanceSource;
import com.android.zxing.NotFoundException;
import com.android.zxing.common.BitArray;
import com.android.zxing.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource source) {
        super(source);
    }

    @Override
    public BitArray getBlackRow(int y, BitArray row) throws NotFoundException {
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        if (row == null || row.getSize() < width) {
            row = new BitArray(width);
        } else {
            row.clear();
        }
        this.initArrays(width);
        byte[] localLuminances = source.getRow(y, this.luminances);
        int[] localBuckets = this.buckets;
        for (int x = 0; x < width; ++x) {
            int n = (localLuminances[x] & 0xFF) >> 3;
            localBuckets[n] = localBuckets[n] + 1;
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        if (width < 3) {
            for (int x = 0; x < width; ++x) {
                if ((localLuminances[x] & 0xFF) >= blackPoint) continue;
                row.set(x);
            }
        } else {
            int left = localLuminances[0] & 0xFF;
            int center = localLuminances[1] & 0xFF;
            for (int x = 1; x < width - 1; ++x) {
                int right = localLuminances[x + 1] & 0xFF;
                if (((center << 2) - left - right) / 2 < blackPoint) {
                    row.set(x);
                }
                left = center;
                center = right;
            }
        }
        return row;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int x;
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        int height = source.getHeight();
        BitMatrix matrix = new BitMatrix(width, height);
        this.initArrays(width);
        int[] localBuckets = this.buckets;
        for (int y = 1; y < 5; ++y) {
            int row = height * y / 5;
            byte[] localLuminances = source.getRow(row, this.luminances);
            int right = (width << 2) / 5;
            for (x = width / 5; x < right; ++x) {
                int pixel = localLuminances[x] & 0xFF;
                int n = pixel >> 3;
                localBuckets[n] = localBuckets[n] + 1;
            }
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        byte[] localLuminances = source.getMatrix();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (x = 0; x < width; ++x) {
                if ((localLuminances[offset + x] & 0xFF) >= blackPoint) continue;
                matrix.set(x, y);
            }
        }
        return matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source) {
        return new GlobalHistogramBinarizer(source);
    }

    private void initArrays(int luminanceSize) {
        if (this.luminances.length < luminanceSize) {
            this.luminances = new byte[luminanceSize];
        }
        for (int x = 0; x < 32; ++x) {
            this.buckets[x] = 0;
        }
    }

    private static int estimateBlackPoint(int[] buckets) throws NotFoundException {
        int numBuckets = buckets.length;
        int maxBucketCount = 0;
        int firstPeak = 0;
        int firstPeakSize = 0;
        for (int x = 0; x < numBuckets; ++x) {
            if (buckets[x] > firstPeakSize) {
                firstPeak = x;
                firstPeakSize = buckets[x];
            }
            if (buckets[x] <= maxBucketCount) continue;
            maxBucketCount = buckets[x];
        }
        int secondPeak = 0;
        int secondPeakScore = 0;
        for (int x = 0; x < numBuckets; ++x) {
            int distanceToBiggest = x - firstPeak;
            int score = buckets[x] * distanceToBiggest * distanceToBiggest;
            if (score <= secondPeakScore) continue;
            secondPeak = x;
            secondPeakScore = score;
        }
        if (firstPeak > secondPeak) {
            int temp = firstPeak;
            firstPeak = secondPeak;
            secondPeak = temp;
        }
        if (secondPeak - firstPeak <= numBuckets / 16) {
            throw NotFoundException.getNotFoundInstance();
        }
        int bestValley = secondPeak - 1;
        int bestValleyScore = -1;
        for (int x = secondPeak - 1; x > firstPeak; --x) {
            int n = x - firstPeak;
            int score = n * n * (secondPeak - x) * (maxBucketCount - buckets[x]);
            if (score <= bestValleyScore) continue;
            bestValley = x;
            bestValleyScore = score;
        }
        return bestValley << 3;
    }
}

