/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.maxicode;

import com.android.zxing.BarcodeFormat;
import com.android.zxing.BinaryBitmap;
import com.android.zxing.ChecksumException;
import com.android.zxing.DecodeHintType;
import com.android.zxing.FormatException;
import com.android.zxing.NotFoundException;
import com.android.zxing.Reader;
import com.android.zxing.Result;
import com.android.zxing.ResultMetadataType;
import com.android.zxing.ResultPoint;
import com.android.zxing.common.BitMatrix;
import com.android.zxing.common.DecoderResult;
import com.android.zxing.maxicode.decoder.Decoder;
import java.util.Map;

public final class MaxiCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private static final int MATRIX_WIDTH = 30;
    private static final int MATRIX_HEIGHT = 33;
    private final Decoder decoder = new Decoder();

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, ChecksumException, FormatException {
        if (hints == null || !hints.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bits = MaxiCodeReader.extractPureBits(image.getBlackMatrix());
        DecoderResult decoderResult = this.decoder.decode(bits, hints);
        ResultPoint[] points = NO_POINTS;
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.MAXICODE);
        String ecLevel = decoderResult.getECLevel();
        if (ecLevel != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix image) throws NotFoundException {
        int[] enclosingRectangle = image.getEnclosingRectangle();
        if (enclosingRectangle == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        int left = enclosingRectangle[0];
        int top = enclosingRectangle[1];
        int width = enclosingRectangle[2];
        int height = enclosingRectangle[3];
        BitMatrix bits = new BitMatrix(30, 33);
        for (int y = 0; y < 33; ++y) {
            int iy = top + (y * height + height / 2) / 33;
            for (int x = 0; x < 30; ++x) {
                int ix = left + (x * width + width / 2 + (y & 1) * width / 2) / 30;
                if (!image.get(ix, iy)) continue;
                bits.set(x, y);
            }
        }
        return bits;
    }
}

