/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.client.result;

import com.android.zxing.BarcodeFormat;
import com.android.zxing.Result;
import com.android.zxing.client.result.ProductParsedResult;
import com.android.zxing.client.result.ResultParser;
import com.android.zxing.oned.UPCEReader;

public final class ProductResultParser
extends ResultParser {
    @Override
    public ProductParsedResult parse(Result result) {
        BarcodeFormat format = result.getBarcodeFormat();
        if (format != BarcodeFormat.UPC_A && format != BarcodeFormat.UPC_E && format != BarcodeFormat.EAN_8 && format != BarcodeFormat.EAN_13) {
            return null;
        }
        String rawText = ProductResultParser.getMassagedText(result);
        if (!ProductResultParser.isStringOfDigits(rawText, rawText.length())) {
            return null;
        }
        String normalizedProductID = format == BarcodeFormat.UPC_E && rawText.length() == 8 ? UPCEReader.convertUPCEtoUPCA(rawText) : rawText;
        return new ProductParsedResult(rawText, normalizedProductID);
    }
}

