/*
 * Decompiled with CFR 0.152.
 */
package com.android.zxing.aztec;

import com.android.zxing.BarcodeFormat;
import com.android.zxing.BinaryBitmap;
import com.android.zxing.DecodeHintType;
import com.android.zxing.FormatException;
import com.android.zxing.NotFoundException;
import com.android.zxing.Reader;
import com.android.zxing.Result;
import com.android.zxing.ResultMetadataType;
import com.android.zxing.ResultPoint;
import com.android.zxing.ResultPointCallback;
import com.android.zxing.aztec.AztecDetectorResult;
import com.android.zxing.aztec.decoder.Decoder;
import com.android.zxing.aztec.detector.Detector;
import com.android.zxing.common.DecoderResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        String ecLevel;
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult;
        NotFoundException notFoundException = null;
        FormatException formatException = null;
        Detector detector = new Detector(image.getBlackMatrix());
        ResultPoint[] points = null;
        DecoderResult decoderResult = null;
        try {
            detectorResult = detector.detect(false);
            points = detectorResult.getPoints();
            decoderResult = new Decoder().decode(detectorResult);
        }
        catch (NotFoundException e) {
            notFoundException = e;
        }
        catch (FormatException e) {
            formatException = e;
        }
        if (decoderResult == null) {
            try {
                detectorResult = detector.detect(true);
                points = detectorResult.getPoints();
                decoderResult = new Decoder().decode(detectorResult);
            }
            catch (FormatException | NotFoundException e) {
                if (notFoundException != null) {
                    throw notFoundException;
                }
                if (formatException != null) {
                    throw formatException;
                }
                throw e;
            }
        }
        if (hints != null && (rpcb = (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            for (ResultPoint point : points) {
                rpcb.foundPossibleResultPoint(point);
            }
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.AZTEC);
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        return result;
    }

    @Override
    public void reset() {
    }
}

